/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.util;

public class NxUtil {
    private NxUtil() {
    }

    public static String escapeForNx(String lit) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < lit.length(); ++i) {
            int cp = lit.codePointAt(i);
            if (!Character.isSupplementaryCodePoint(cp)) {
                char c = (char)cp;
                switch (c) {
                    case '\\': {
                        result.append("\\\\");
                        break;
                    }
                    case '\"': {
                        result.append("\\\"");
                        break;
                    }
                    case '\n': {
                        result.append("\\n");
                        break;
                    }
                    case '\r': {
                        result.append("\\r");
                        break;
                    }
                    case '\t': {
                        result.append("\\t");
                        break;
                    }
                    default: {
                        if (c >= '\u0000' && c <= '\b' || c == '\u000b' || c == '\f' || c >= '\u000e' && c <= '\u001f' || c >= '\u007f' && c <= '\uffff') {
                            result.append("\\u");
                            result.append(NxUtil.toHexString(c, 4));
                            break;
                        }
                        result.append(c);
                        break;
                    }
                }
                continue;
            }
            result.append("\\U");
            result.append(NxUtil.toHexString(cp, 8));
            ++i;
        }
        return result.toString();
    }

    public static String escapeForMarkup(String lit) {
        String unescaped = NxUtil.unescape(lit);
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < unescaped.length(); ++i) {
            int cp = unescaped.codePointAt(i);
            if (!Character.isSupplementaryCodePoint(cp)) {
                char c = (char)cp;
                switch (c) {
                    case '&': {
                        result.append("&amp;");
                        break;
                    }
                    case '<': {
                        result.append("&lt;");
                        break;
                    }
                    case '>': {
                        result.append("&gt;");
                        break;
                    }
                    case '\"': {
                        result.append("&quot;");
                        break;
                    }
                    case '\'': {
                        result.append("&#039;");
                        break;
                    }
                    case '\\': {
                        result.append("&#092;");
                        break;
                    }
                    default: {
                        if (c >= '\u0000' && c <= '\b' || c == '\u000b' || c == '\f' || c >= '\u000e' && c <= '\u001f' || c >= '\u007f' && c <= '\uffff') {
                            result.append("&#x");
                            result.append(NxUtil.toHexString(c, 4));
                            result.append(";");
                            break;
                        }
                        result.append(c);
                        break;
                    }
                }
                continue;
            }
            result.append("&#x");
            result.append(NxUtil.toHexString(cp, 8));
            result.append(";");
            ++i;
        }
        return result.toString();
    }

    private static String toHexString(int decimal, int stringLength) {
        return String.format("%0" + stringLength + "X", decimal);
    }

    public static String unescape(String str) {
        return NxUtil.unescape(str, false);
    }

    public static String unescape(String str, boolean clean) {
        if (clean) {
            str = NxUtil.cleanSlashes(str);
        }
        int sz = str.length();
        StringBuffer buffer = new StringBuffer(sz);
        StringBuffer unicode = new StringBuffer(6);
        boolean hadSlash = false;
        boolean inUnicode = false;
        boolean inSpecialUnicode = false;
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (inUnicode && unicode.length() < 4) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    buffer.append((char)value);
                    unicode = new StringBuffer(4);
                    inUnicode = false;
                    inSpecialUnicode = false;
                    hadSlash = false;
                }
                catch (NumberFormatException nfe) {
                    buffer.append(unicode.toString());
                }
                continue;
            }
            if (inSpecialUnicode && unicode.length() < 8) {
                unicode.append(ch);
                if (unicode.length() != 8) continue;
                try {
                    buffer.appendCodePoint(Integer.parseInt(unicode.toString(), 16));
                    unicode = new StringBuffer(8);
                    inUnicode = false;
                    inSpecialUnicode = false;
                    hadSlash = false;
                }
                catch (NumberFormatException nfe) {
                    buffer.append(unicode.toString());
                }
                continue;
            }
            if (hadSlash) {
                hadSlash = false;
                switch (ch) {
                    case '\\': {
                        buffer.append('\\');
                        break;
                    }
                    case '\'': {
                        buffer.append('\'');
                        break;
                    }
                    case '\"': {
                        buffer.append('\"');
                        break;
                    }
                    case 'r': {
                        buffer.append('\r');
                        break;
                    }
                    case 'f': {
                        buffer.append('\f');
                        break;
                    }
                    case 't': {
                        buffer.append('\t');
                        break;
                    }
                    case 'n': {
                        buffer.append('\n');
                        break;
                    }
                    case 'b': {
                        buffer.append('\b');
                        break;
                    }
                    case 'u': {
                        inUnicode = true;
                        break;
                    }
                    case 'U': {
                        inSpecialUnicode = true;
                        break;
                    }
                    default: {
                        buffer.append(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            buffer.append(ch);
        }
        if (hadSlash) {
            buffer.append('\\');
        }
        return buffer.toString();
    }

    private static String cleanSlashes(String str) {
        while (str.indexOf("\\\\") != -1) {
            str = str.replaceAll("\\\\\\\\", "\\\\");
        }
        return str;
    }
}

