/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.stats;

import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.namespace.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface NodeTransformer<E> {
    public E[] processNode(Node[] var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NamespaceHashTransformer
    implements NodeTransformer<Integer> {
        public static final int EMPTY_NS_HASH = 0;

        public Integer[] processNode(Node[] na) {
            Integer[] nshs = new Integer[na.length];
            for (int i = 0; i < na.length; ++i) {
                String ns = Namespace.getNamespace(na[i]);
                nshs[i] = ns == null ? Integer.valueOf(0) : Integer.valueOf(ns.hashCode());
            }
            return nshs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NamespaceTransformer
    implements NodeTransformer<String> {
        public static final String EMPTY_NS = "N/A";

        public String[] processNode(Node[] na) {
            String[] nss = new String[na.length];
            for (int i = 0; i < na.length; ++i) {
                nss[i] = Namespace.getNamespace(na[i]);
                if (nss[i] != null) continue;
                nss[i] = EMPTY_NS;
            }
            return nss;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HashTransformer
    implements NodeTransformer<Integer> {
        public Integer[] processNode(Node[] na) {
            Integer[] hs = new Integer[na.length];
            for (int i = 0; i < na.length; ++i) {
                hs[i] = na[i].hashCode();
            }
            return hs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NoTransformer
    implements NodeTransformer<Node> {
        public Node[] processNode(Node[] n) {
            return n;
        }
    }
}

