/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.parser.Callback;

public class CallbackNxBufferedWriter
implements Callback {
    final BufferedWriter _bw;
    long _cnt = 0L;
    long _time;
    long _time1;
    final boolean _close;
    public static final Charset DEFAULTCHARSET = Charset.forName("US-ASCII");
    public static final String DOTNEWLINE = "." + System.getProperty("line.separator");
    public static final byte[] SPACE = " ".getBytes();
    public static final byte[] DOT_NEWLINE = DOTNEWLINE.getBytes();

    public CallbackNxBufferedWriter(BufferedWriter out) {
        this(out, false);
    }

    public CallbackNxBufferedWriter(BufferedWriter out, boolean close) {
        this._bw = out;
        this._close = close;
    }

    public synchronized void processStatement(Node[] nx) {
        try {
            for (Node n : nx) {
                this._bw.write(n.toN3());
                this._bw.write(32);
            }
            this._bw.write(DOTNEWLINE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ++this._cnt;
    }

    public void startDocument() {
        this._time = System.currentTimeMillis();
    }

    public void endDocument() {
        try {
            if (this._close) {
                this._bw.close();
            } else {
                this._bw.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this._time1 = System.currentTimeMillis();
    }

    public String toString() {
        return this._cnt + " tuples in " + (this._time1 - this._time) + " ms";
    }
}

