/*
 * Decompiled with CFR 0.152.
 */
package de.xam.ksource.impl.itemtxt;

import de.xam.itemset.IItem;
import de.xam.ksource.impl.itemtxt.DataFileFormat;
import de.xam.ksource.impl.itemtxt.DataFileSourceItem;
import de.xam.mybase.model.names.IdManager;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.xydra.base.XId;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;

public class ExternalFileFormat {
    protected static void tryToReadAsHelperFileToMyBase(File f, DataFileFormat.IWriteMyBase myBase) throws IOException {
        String[] parts = f.getName().split("[.]");
        if (parts.length != 3) {
            DataFileSourceItem.log.trace("Skipping file '" + f.getAbsolutePath() + "' which has the wrong file name syntax. Looking for foo.bar.baz as itemId.propId.extension");
            return;
        }
        try {
            XId itemId = IdManager.toFastRawId((String)parts[0]);
            String propKey = parts[1];
            XId propId = DataFileFormat.extractPropertyId(propKey);
            IItem item = myBase.getItemById(itemId);
            if (item == null) {
                DataFileSourceItem.log.warn("Could not find item with id '" + itemId + "', ignoring file '" + f.getAbsolutePath() + "'");
                return;
            }
            String extension = parts[2];
            if (extension.equals("txt")) {
                String str = FileUtils.readFileToString((File)f, (String)"utf-8");
                item.setAttribute(propId, (XValue)XV.toValue((String)str));
            } else {
                byte[] bytes = FileUtils.readFileToByteArray((File)f);
                item.setAttribute(propId, (XValue)XV.toValue((byte[])bytes));
            }
        }
        catch (IllegalArgumentException e) {
            DataFileSourceItem.log.warn("Could not create XIds from file name parts of file '" + f.getAbsolutePath() + "'. Skipping file.");
            return;
        }
    }

    static void writeSpecialPropertyValueToFile(File rootDir, XId s, XId p, XValue o, String extension) throws IOException {
        String propertyKey = DataFileFormat.toPropertyKey(p);
        File f = new File(rootDir, s + "." + propertyKey + "." + extension);
        if (extension.equals("txt")) {
            String data = XV.toString((XValue)o);
            FileUtils.writeStringToFile((File)f, (String)data, (String)"utf-8");
        } else {
            byte[] data = XV.toBinary((XValue)o);
            FileUtils.writeByteArrayToFile((File)f, (byte[])data);
        }
    }
}

