/*
 * Decompiled with CFR 0.152.
 */
package de.xam.color;

import de.xam.color.ColorTool;
import de.xam.color.RGBColor;

public class HSLColor {
    private static final double OPAQUE = 1.0;
    private double hue;
    private double saturation;
    private double luminance;
    private double alpha = 0.0;
    public static int ROUNDING_PRECISION = 3;
    public static final HSLColor BLACK = new HSLColor(0.0, 0.0, 0.0);
    public static final HSLColor WHITE = new HSLColor(0.0, 0.0, 1.0);

    public HSLColor(double hue, double saturation, double luminance) {
        this(hue, saturation, luminance, 1.0);
        HSLColor.assertRange360(hue);
        HSLColor.assertRange1(saturation);
        HSLColor.assertRange1(luminance);
    }

    private static void assertRange360(double d) {
        assert (0.0 <= d && d <= 360.0);
    }

    public HSLColor(double hue, double saturation, double luminance, double alpha) {
        this.hue = hue;
        this.saturation = saturation;
        this.luminance = luminance;
        this.alpha = alpha;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getHue360() {
        return this.hue;
    }

    public double getHue1() {
        return this.getHue360() / 360.0;
    }

    public double getLuminance() {
        return this.luminance;
    }

    public double getSaturation() {
        return this.saturation;
    }

    public String toString() {
        return "H=" + this.hue + "\u00b0,S=" + this.saturation + "%,L=" + this.luminance + "%,alpha=" + this.alpha;
    }

    public RGBColor toRGB() {
        return ColorTool.hslToRgb(this);
    }

    public HSLColor desaturate(double d) {
        HSLColor.assertRange1(d);
        return new HSLColor(this.getHue360(), this.getSaturation() - d * this.getSaturation(), this.getLuminance(), this.getAlpha());
    }

    public HSLColor saturate(double d) {
        HSLColor.assertRange1(d);
        return new HSLColor(this.getHue360(), this.getSaturation() + d * (1.0 - this.getSaturation()), this.getLuminance(), this.getAlpha());
    }

    public HSLColor shade(double d) {
        HSLColor.assertRange1(d);
        return new HSLColor(this.getHue360(), this.getSaturation(), this.getLuminance() - d * this.getLuminance(), this.getAlpha());
    }

    private static void assertRange1(double d) {
        assert (0.0 <= d && d <= 1.0);
    }

    public HSLColor tint(double d) {
        HSLColor.assertRange1(d);
        double missingLum = 1.0 - this.getLuminance();
        return new HSLColor(this.getHue360(), this.getSaturation(), this.getLuminance() + d * missingLum, this.getAlpha());
    }

    public boolean isPure() {
        return this.getSaturation() == 1.0;
    }

    public HSLColor minus(HSLColor other) {
        return new HSLColor(this.getHue360() - other.getHue360(), this.getSaturation() - other.getSaturation(), this.getLuminance() - other.getLuminance(), this.getAlpha() - other.getAlpha());
    }

    public String toCssHSLA() {
        return "hsla(" + this.getHue360() + ", " + 100.0 * this.getSaturation() + "%, " + 100.0 * this.getLuminance() + "%, " + this.getAlpha() + ")";
    }

    public static void main(String[] args) {
        RGBColor rgb = ColorTool.parse("#E4AEAE");
        System.out.println(rgb.toCssHex());
        System.out.println(rgb.toHSL());
        System.out.println(rgb.toHSL().toCssHSLA());
    }

    public String getHueRounded() {
        return HSLColor.format(this.getHue1(), ROUNDING_PRECISION);
    }

    public String getSaturationRounded() {
        return HSLColor.format(this.getSaturation(), ROUNDING_PRECISION);
    }

    public String getLuminanceRounded() {
        return HSLColor.format(this.getLuminance(), ROUNDING_PRECISION);
    }

    public String getAlphaRounded() {
        return HSLColor.format(this.getAlpha(), ROUNDING_PRECISION);
    }

    public static String format(double d, int digitsAfterDot) {
        String s = "" + d;
        int i = s.indexOf(".");
        String[] parts = s.split("\\.");
        parts[1] = parts[1] + "00000000000000000000";
        if (parts[i].length() > digitsAfterDot) {
            parts[i] = parts[i].substring(0, digitsAfterDot);
        }
        return parts[0] + "." + parts[1];
    }

    public HSLColor setAlpha(double alpha) {
        this.alpha = alpha;
        return this;
    }

    public HSLColor getReadable() {
        return this.getReadable(WHITE, BLACK);
    }

    public HSLColor getReadable(HSLColor whitish, HSLColor blackish) {
        if (this.getLuminance() < 0.5) {
            return whitish;
        }
        return blackish;
    }

    public HSLColor moveLuminanceToMiddle(double d) {
        HSLColor c = this.copy();
        c.luminance = this.getLuminance() < 0.5 ? (c.luminance += d * (0.5 - c.luminance)) : (c.luminance -= d * (c.luminance - 0.5));
        return c;
    }

    private HSLColor copy() {
        return new HSLColor(this.getHue360(), this.getSaturation(), this.getLuminance(), this.getAlpha());
    }
}

