/*
 * Decompiled with CFR 0.152.
 */
package de.xam.memspace;

import de.xam.memspace.IObjectProfileNode;
import de.xam.memspace.ObjectProfileFilters;
import de.xam.memspace.ObjectProfileVisitors;
import de.xam.memspace.ObjectProfiler;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class Memspace {
    public static void dumpStats(Object obj, double fraction) {
        IObjectProfileNode profile = ObjectProfiler.profile(obj);
        System.out.println("size fraction filter with threshold=" + fraction);
        PrintWriter out = new PrintWriter(System.out);
        try {
            profile.traverse(ObjectProfileFilters.newSizeFractionFilter(fraction), ObjectProfileVisitors.newDefaultNodePrinter(out, null, null, true));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getStats(Object obj, double fraction) {
        IObjectProfileNode profile = ObjectProfiler.profile(obj);
        System.out.println("size fraction filter with threshold=" + fraction);
        StringWriter w = new StringWriter();
        try {
            profile.traverse(ObjectProfileFilters.newSizeFractionFilter(fraction), ObjectProfileVisitors.newDefaultNodePrinter(w, null, null, true));
            return w.getBuffer().toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getSizeInBytes(Object o) {
        IObjectProfileNode profile = ObjectProfiler.profile(o);
        return profile.size();
    }

    public static void writeStats(Object obj, double fraction, String[] classnamesToIgnore, Writer w) throws IOException {
        assert (obj != null);
        assert (classnamesToIgnore != null);
        IObjectProfileNode profile = ObjectProfiler.profile(obj, classnamesToIgnore);
        w.write("size fraction filter with threshold=" + fraction + "<br />");
        w.write("<pre>");
        PrintWriter out = new PrintWriter(w);
        profile.traverse(ObjectProfileFilters.newSizeFractionFilter(fraction), ObjectProfileVisitors.newDefaultNodePrinter(out, null, null, true));
        w.write("</pre>");
    }

    public static void writeStats(Object obj, double fraction, Writer w) throws IOException {
        IObjectProfileNode profile = ObjectProfiler.profile(obj);
        w.write("size fraction filter with threshold=" + fraction + "<br />");
        w.write("<pre>");
        PrintWriter out = new PrintWriter(w);
        profile.traverse(ObjectProfileFilters.newSizeFractionFilter(fraction), ObjectProfileVisitors.newDefaultNodePrinter(out, null, null, true));
        w.write("</pre>");
    }
}

