/*
 * Decompiled with CFR 0.152.
 */
package de.xam.textsearch.compare;

import de.xam.textsearch.Match;
import de.xam.textsearch.spi.IContentResolver;
import java.util.Comparator;

public class PrefixMatchFirstComparator<V>
implements Comparator<Match<V>> {
    private final String prefix;
    private final IContentResolver<V> contentResolver;

    public PrefixMatchFirstComparator(IContentResolver<V> contentResolver, String prefix) {
        this.contentResolver = contentResolver;
        this.prefix = prefix;
    }

    @Override
    public int compare(Match<V> a, Match<V> b) {
        boolean matchA = this.contentResolver.getContentAsStringForTextIndexing(a.getValue()).toLowerCase().startsWith(this.prefix.toLowerCase());
        boolean matchB = this.contentResolver.getContentAsStringForTextIndexing(b.getValue()).toLowerCase().startsWith(this.prefix.toLowerCase());
        if (matchA) {
            if (matchB) {
                return 0;
            }
            return -1;
        }
        if (matchB) {
            return 1;
        }
        return 0;
    }
}

