/*
 * Decompiled with CFR 0.152.
 */
package de.xam.textsearch.compare;

import de.xam.textsearch.Match;
import de.xam.textsearch.spi.IContentResolver;
import java.util.Comparator;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class ShortestFirstMatchComparator<V>
implements Comparator<Match<V>> {
    private final IContentResolver<V> contentResolver;
    private static final Logger log = LoggerFactory.getLogger(ShortestFirstMatchComparator.class);

    public ShortestFirstMatchComparator(IContentResolver<V> contentResolver) {
        this.contentResolver = contentResolver;
    }

    @Override
    public int compare(Match<V> a, Match<V> b) {
        return ShortestFirstMatchComparator.compare_static(a, b, this.contentResolver);
    }

    public static <T> int compare_static(Match<T> a, Match<T> b, IContentResolver<T> contentResolver) {
        String aContent = contentResolver.getContentAsStringForTextIndexing(a.getValue());
        String bContent = contentResolver.getContentAsStringForTextIndexing(b.getValue());
        if (aContent == null) {
            log.warn("No content for match A " + a);
        }
        if (bContent == null) {
            log.warn("No content for match B " + b);
        }
        if (aContent == null) {
            if (bContent == null) {
                return 0;
            }
            return 1;
        }
        if (bContent == null) {
            return -1;
        }
        return aContent.length() - bContent.length();
    }
}

