/*
 * Decompiled with CFR 0.152.
 */
package de.xam.textsearch.text;

import com.google.gwt.regexp.shared.SplitResult;
import de.xam.textsearch.compare.LongestStringComparator;
import de.xam.textsearch.fragment.FragmentIndex;
import de.xam.textsearch.fragment.FragmentQuery;
import de.xam.textsearch.query.AndQuery;
import de.xam.textsearch.query.IQuery;
import de.xam.textsearch.text.ITextQuery;
import de.xam.textsearch.text.TextQuery;
import de.xam.textsearch.tokenize.ITokenizer;
import de.xam.textsearch.tokenize.Tokenizers;
import de.xam.textsearch.util.INormaliser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xydra.index.IEntrySet;
import org.xydra.index.impl.trie.SmallTrieStringMapSetIndex;
import org.xydra.index.iterator.ClosableIterator;
import org.xydra.index.iterator.IFilter;
import org.xydra.index.query.Constraint;
import org.xydra.index.query.KeyEntryTuple;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class TextIndex<V extends Serializable>
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(TextIndex.class);
    private static final long serialVersionUID = 1L;
    private FragmentIndex<V> fragmentIndex = new FragmentIndex();
    private transient INormaliser normaliser;
    private transient ITokenizer phrase2fragmentTokenizer;
    private transient ITokenizer phrase2wordTokenizer;

    private static <V extends Serializable> FragmentQuery<V> createFragmentQuery(FragmentIndex<V> fragmentIndex, String fragment, boolean prefixMatch) {
        return FragmentQuery.create(fragmentIndex, fragment, prefixMatch);
    }

    public static <V extends Serializable> ITextQuery<V> createTextQuery(FragmentIndex<V> fragmentIndex, ITokenizer phrase2wordTokenizer, ITokenizer phrase2fragmentTokenizer, INormaliser normaliser, String queryPhrase, IFilter<V> optionalValueFilter, boolean prefixQuery) {
        FragmentQuery<V> fragmentQuery;
        List<String> wordList = TextIndex.tokenizeToWordList(phrase2wordTokenizer, queryPhrase);
        ArrayList<String> fragmentList = new ArrayList<String>();
        SplitResult fragments = phrase2fragmentTokenizer.split(queryPhrase);
        for (int i = 0; i < fragments.length(); ++i) {
            String fragment = fragments.get(i);
            if (fragmentList.contains(fragment)) continue;
            fragmentList.add(fragment);
        }
        TextQuery<V> textquery = new TextQuery<V>(queryPhrase, wordList, fragmentList);
        HashSet<String> usedParts = new HashSet<String>();
        for (String word : wordList) {
            String normalisedWord = normaliser.normalise(word);
            if (normalisedWord == null || usedParts.contains(normalisedWord)) continue;
            fragmentQuery = TextIndex.createFragmentQuery(fragmentIndex, normalisedWord, prefixQuery).setValueFilter(optionalValueFilter);
            textquery.or(fragmentQuery);
            usedParts.add(normalisedWord);
        }
        for (int i = 0; i < fragments.length(); ++i) {
            String fragment = fragments.get(i);
            String normalisedFragment = normaliser.normalise(fragment);
            if (usedParts.contains(normalisedFragment)) continue;
            fragmentQuery = TextIndex.createFragmentQuery(fragmentIndex, normalisedFragment, prefixQuery).setValueFilter(optionalValueFilter);
            textquery.or(fragmentQuery);
        }
        return textquery;
    }

    private static <V extends Serializable> IQuery<V> toAndQuery(FragmentIndex<V> fragmentIndex, ITokenizer phrase2fragmentTokenizer, INormaliser normaliser, String queryPhrase, IFilter<V> optionalValueFilter, boolean prefixMatch) {
        boolean queryForEverything = false;
        if (queryPhrase.length() == 0) {
            queryForEverything = true;
        }
        SplitResult fragments = null;
        if (!queryForEverything && (fragments = phrase2fragmentTokenizer.split(queryPhrase)).length() == 0) {
            assert (queryPhrase.length() > 0);
            log.trace("no fragments, but queryString '" + queryPhrase + "' present. QueryString seems to consist only of special characters such as '_'");
            queryForEverything = true;
        }
        if (queryForEverything) {
            FragmentQuery<V> fragmentQuery = TextIndex.createFragmentQuery(fragmentIndex, "", prefixMatch);
            fragmentQuery.setValueFilter(optionalValueFilter);
            return fragmentQuery;
        }
        assert (!queryForEverything);
        assert (fragments != null);
        assert (fragments.length() > 0);
        AndQuery<V> combined = AndQuery.create();
        for (int i = 0; i < fragments.length(); ++i) {
            String fragment = fragments.get(i);
            String normalisedFragment = normaliser.normalise(fragment);
            FragmentQuery<V> fragmentQuery = TextIndex.createFragmentQuery(fragmentIndex, normalisedFragment, prefixMatch);
            fragmentQuery.setValueFilter(optionalValueFilter);
            combined.and(fragmentQuery);
        }
        return combined;
    }

    public static List<String> tokenizeToWordList(ITokenizer phrase2wordTokenizer, String queryPhrase) {
        ArrayList<String> wordList = new ArrayList<String>();
        SplitResult words = phrase2wordTokenizer.split(queryPhrase);
        for (int i = 0; i < words.length(); ++i) {
            String word = words.get(i);
            if (word.length() == 0 || wordList.contains(word)) continue;
            wordList.add(word);
        }
        return wordList;
    }

    public TextIndex() {
        this(INormaliser.LOWERCASE, Tokenizers.PHRASE_2_WORD_TOKENIZER__RANGEBASED, Tokenizers.WORD_OR_PHRASE_2_FRAGMENT_TOKENIZER__RANGEBASED);
    }

    public TextIndex(INormaliser normaliser, ITokenizer phrase2words, ITokenizer phrase2fragments) {
        this.normaliser = normaliser;
        this.phrase2wordTokenizer = phrase2words;
        this.phrase2fragmentTokenizer = phrase2fragments;
    }

    public void clear() {
        this.fragmentIndex.clear();
    }

    public ClosableIterator<V> constraintFragmentIterator(Constraint<String> fragmentConstraint) {
        return this.fragmentIndex.constraintIterator(fragmentConstraint);
    }

    public boolean containsFragment(String fragment) {
        return this.fragmentIndex.containsKey(fragment);
    }

    public boolean containsFragmentsMatching(Constraint<String> fragmentConstraint, Constraint<V> idConstraint) {
        return this.fragmentIndex.contains(fragmentConstraint, idConstraint);
    }

    public FragmentQuery<V> createFragmentQuery(String fragment, boolean prefixMatch) {
        return FragmentQuery.create(this.fragmentIndex, fragment, prefixMatch);
    }

    public IQuery<V> createAndQuery(Set<String> fragments, boolean prefixMatch) {
        if (fragments.size() == 1) {
            return this.createFragmentQuery(fragments.iterator().next(), prefixMatch);
        }
        ArrayList<String> longestFirst = new ArrayList<String>(fragments.size());
        longestFirst.addAll(fragments);
        Collections.sort(longestFirst, new LongestStringComparator());
        AndQuery<V> andQuery = new AndQuery<V>();
        for (String fragment : longestFirst) {
            FragmentQuery<V> fragmentQuery = this.createFragmentQuery(fragment, prefixMatch);
            andQuery.and(fragmentQuery);
        }
        return andQuery;
    }

    public ITextQuery<V> createTextQuery(String queryPhrase, IFilter<V> optionalValueFilter, boolean prefixQUery) {
        return TextIndex.createTextQuery(this.fragmentIndex, this.phrase2wordTokenizer, this.phrase2fragmentTokenizer, this.normaliser, queryPhrase, optionalValueFilter, prefixQUery);
    }

    public void deIndexFragment(String fragment) {
        this.fragmentIndex.deIndex(fragment);
    }

    public boolean deIndexFragment(String fragment, V id) {
        return this.fragmentIndex.deIndex(fragment, id);
    }

    public void deIndexText(String phrase, V id) {
        SplitResult phraseSplit = this.phrase2fragmentTokenizer.split(phrase);
        for (int i = 0; i < phraseSplit.length(); ++i) {
            String fragment = phraseSplit.get(i);
            String normalisedFragment = this.normaliser.normalise(fragment);
            this.deIndexFragment(normalisedFragment, id);
        }
    }

    public void dump() {
        this.fragmentIndex.dump();
    }

    public boolean equals(Object obj) {
        return obj instanceof TextIndex && this.fragmentIndex.equals(((TextIndex)obj).fragmentIndex);
    }

    public ClosableIterator<KeyEntryTuple<String, V>> fragmentIdTupleIterator(Constraint<String> fragmentConstraint, Constraint<V> idConstraint) {
        return this.fragmentIndex.tupleIterator(fragmentConstraint, idConstraint);
    }

    public Iterator<V> fragmentQuery(FragmentQuery<V> fragmentQuery) {
        return this.fragmentIndex.executeQuery(fragmentQuery);
    }

    public ClosableIterator<Set<V>> fragmentQueryAsSets(FragmentQuery<V> fragmentQuery) {
        return this.fragmentIndex.executeQueryAsSets(fragmentQuery);
    }

    public ClosableIterator<String> fragmentsIterator() {
        return this.fragmentIndex.keyIterator();
    }

    public Pair<Integer, Set<V>> getLongestMatch(String text, int start) {
        return this.fragmentIndex.getLongestMatch(text, start);
    }

    public int hashCode() {
        return this.fragmentIndex.hashCode();
    }

    public boolean indexFragment(String fragment, V id) {
        return this.fragmentIndex.index(fragment, id);
    }

    public void indexText(String phrase, V id) {
        assert (phrase != null);
        SplitResult phraseSplit = this.phrase2fragmentTokenizer.split(phrase);
        for (int i = 0; i < phraseSplit.length(); ++i) {
            String fragment = phraseSplit.get(i);
            String normalisedFragment = this.normaliser.normalise(fragment);
            this.indexFragment(normalisedFragment, id);
        }
    }

    public boolean isEmpty() {
        return this.fragmentIndex.isEmpty();
    }

    public IEntrySet<V> lookupFragment(String fragment) {
        return this.fragmentIndex.lookup(fragment);
    }

    public Set<V>[] query(FragmentQuery<V> ... queries) {
        if (queries == null || queries.length == 0) {
            return new Set[0];
        }
        Set[] result = new Set[queries.length];
        for (int i = 0; i < result.length; ++i) {
            Set<V> singleSet;
            ClosableIterator<Set<V>> it = this.fragmentQueryAsSets(queries[i]);
            result[i] = singleSet = this.toSingleSet((Iterator<Set<V>>)it);
        }
        return result;
    }

    public String toDebugString() {
        return this.fragmentIndex.toDebugString();
    }

    public Set<String> toNormalisedFragments(String phrase) {
        if (phrase == null) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        SplitResult phraseSplit = this.phrase2fragmentTokenizer.split(phrase);
        for (int i = 0; i < phraseSplit.length(); ++i) {
            String fragment = phraseSplit.get(i);
            String normalisedFragment = this.normaliser.normalise(fragment);
            set.add(normalisedFragment);
        }
        if (set.isEmpty()) {
            log.trace("Phrase '" + phrase + "' is weird, results in no fragments. Indexing as-is.");
            set.add(phrase);
        }
        return set;
    }

    private Set<V> toSingleSet(Iterator<Set<V>> it) {
        if (!it.hasNext()) {
            return Collections.emptySet();
        }
        Set<V> set1 = it.next();
        if (it.hasNext()) {
            HashSet<V> union = new HashSet<V>();
            while (it.hasNext()) {
                Set<V> eset = it.next();
                union.addAll(eset);
            }
            return union;
        }
        return Collections.unmodifiableSet(set1);
    }

    public String toString() {
        return this.fragmentIndex.toString();
    }

    public void updateIndexText(String oldPhrase, String newPhrase, V id) {
        assert (oldPhrase != null || newPhrase != null) : "old&new are null";
        Set<String> oldFragments = this.toNormalisedFragments(oldPhrase);
        Set<String> newFragments = this.toNormalisedFragments(newPhrase);
        HashSet<String> addedFragments = new HashSet<String>(newFragments.size());
        for (String s : newFragments) {
            if (oldFragments.contains(s)) continue;
            addedFragments.add(s);
        }
        Set<String> removedFragments = oldFragments;
        removedFragments.removeAll(newFragments);
        for (String r : removedFragments) {
            this.deIndexFragment(r, id);
        }
        for (String a : addedFragments) {
            this.indexFragment(a, id);
            assert (this.lookupFragment(a).contains(id));
        }
    }

    public void setInternalIndexState(SmallTrieStringMapSetIndex.Node rootNode) {
        this.fragmentIndex.getInternalIndexState().setRootNote(rootNode);
    }

    public SmallTrieStringMapSetIndex.Node getInternalIndexState() {
        return this.fragmentIndex.getInternalIndexState().getRootNode();
    }

    public int size() {
        return this.fragmentIndex.size();
    }
}

