/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.rest;

import com.calpano.common.server.admin.ConfigurationService;
import com.calpano.common.server.rest.SystemVariables;
import org.xydra.common.NanoClock;
import org.xydra.conf.IConfig;
import org.xydra.conf.annotations.RequireConfInstance;
import org.xydra.env.Env;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.persistence.XydraPersistence;
import org.xydra.restless.IRestlessContext;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessExceptionHandler;
import org.xydra.store.XydraPlatformRuntime;
import org.xydra.store.XydraRuntime;

@RequireConfInstance(value={XydraPlatformRuntime.class})
public class CommonRestlessApp {
    private static final Logger log = LoggerFactory.getLogger(CommonRestlessApp.class);

    public static void restless(Restless restless, String prefix) {
        NanoClock clock = new NanoClock();
        clock.start();
        IConfig conf = Env.get().conf();
        ConfigurationService.addParamsFromWebXml(restless, conf);
        restless.addExceptionHandler(new RestlessExceptionHandler(){

            public boolean handleException(Throwable t, IRestlessContext context) {
                System.err.println("Restless error");
                throw new RuntimeException("" + context.getRequest(), t);
            }
        });
        clock.stop("common-add-execeptionhandler");
        clock.start();
        CommonRestlessApp.setupXydra(restless);
        clock.stop("common-setup-xydra");
        clock.start();
        ConfigurationService.restless(restless, prefix);
        clock.stop("common-ServerSettings");
        clock.start();
        SystemVariables.restless(restless, prefix);
        clock.stop("common-SystemVariables");
        clock.start();
        clock.start();
        clock.stop("common-MailTestResource");
        log.info("Performance: " + clock.getStats());
    }

    public static void setupXydra(Restless restless) {
        XydraPlatformRuntime platformRuntime = (XydraPlatformRuntime)Env.get().conf().resolve(XydraPlatformRuntime.class);
        XydraRuntime.setPlatformRuntime((XydraPlatformRuntime)platformRuntime);
    }

    public static XydraPersistence getXydraPersistence(Restless restless) {
        return (XydraPersistence)restless.getServletContextAttribute("org.xydra.persistence");
    }
}

