/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.services.crashreport;

import org.xydra.log.api.ILogListener;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.IRestlessContext;
import org.xydra.restless.Restless;
import org.xydra.sharedutils.ReflectionUtils;

public class RequestLogTool
implements ILogListener,
Restless.IRequestListener {
    private static LogBuffer firstbuffer = new LogBuffer(8192);
    private static LogBuffer secondbuffer = new LogBuffer(32768);

    public static StringBuilder getLog() {
        return ((StringBuilder)firstbuffer.get()).append("...))) INIT \n    ~~~~~~~~~~~ new log buffer ~~~~~~~~~~~ \nTAIL ... (((\n").append((CharSequence)secondbuffer.get());
    }

    private static synchronized void log(String level, Logger log, String msg) {
        RequestLogTool.log(level, log, msg, null);
    }

    private static synchronized void log(String level, Logger log, String msg, Throwable t) {
        LogBuffer buffer = firstbuffer.isFull() ? secondbuffer : firstbuffer;
        ((StringBuilder)buffer.get()).append(level.toUpperCase()).append(" : ").append(msg).append(" at ").append(log.getClass().getCanonicalName()).append(".(").append(log.getClass().getSimpleName()).append(".java:??) <br/>\n");
        if (t != null) {
            String stacktrace = ReflectionUtils.firstNLines((Throwable)t, (int)300);
            ((StringBuilder)buffer.get()).append(stacktrace);
        }
        if (buffer == secondbuffer && secondbuffer.isFull()) {
            StringBuilder sb = (StringBuilder)secondbuffer.get();
            boolean start = false;
            int end = sb.length() - secondbuffer.maxSizeInChars + 1;
            ((StringBuilder)secondbuffer.get()).delete(0, end);
        }
    }

    public static void start(Restless restless) {
        RequestLogTool requestLogTool = new RequestLogTool();
        LoggerFactory.addLogListener((ILogListener)requestLogTool);
        restless.addRequestListener((Restless.IRequestListener)requestLogTool);
    }

    public void debug(Logger log, String msg) {
        if (!log.isDebugEnabled()) {
            return;
        }
        RequestLogTool.log("debug", log, msg);
    }

    public void debug(Logger log, String msg, Throwable t) {
        if (!log.isDebugEnabled()) {
            return;
        }
        RequestLogTool.log("debug", log, msg, t);
    }

    public void error(Logger log, String msg) {
        if (!log.isErrorEnabled()) {
            return;
        }
        RequestLogTool.log("error", log, msg);
    }

    public void error(Logger log, String msg, Throwable t) {
        if (!log.isErrorEnabled()) {
            return;
        }
        RequestLogTool.log("error", log, msg, t);
    }

    public void info(Logger log, String msg) {
        if (!log.isInfoEnabled()) {
            return;
        }
        RequestLogTool.log("info", log, msg);
    }

    public void info(Logger log, String msg, Throwable t) {
        if (!log.isInfoEnabled()) {
            return;
        }
        RequestLogTool.log("info", log, msg, t);
    }

    public synchronized void onRequestFinished(IRestlessContext restlessContext) {
    }

    public synchronized void onRequestStarted(IRestlessContext restlessContext) {
        firstbuffer.clear();
        secondbuffer.clear();
    }

    public void trace(Logger log, String msg) {
        if (!log.isTraceEnabled()) {
            return;
        }
        RequestLogTool.log("trace", log, msg);
    }

    public void trace(Logger log, String msg, Throwable t) {
        if (!log.isTraceEnabled()) {
            return;
        }
        RequestLogTool.log("trace", log, msg, t);
    }

    public void warn(Logger log, String msg) {
        if (!log.isWarnEnabled()) {
            return;
        }
        RequestLogTool.log("warn", log, msg);
    }

    public void warn(Logger log, String msg, Throwable t) {
        if (!log.isWarnEnabled()) {
            return;
        }
        RequestLogTool.log("warn", log, msg, t);
    }

    private static class LogBuffer
    extends ThreadLocal<StringBuilder> {
        private final int maxSizeInChars;

        public LogBuffer(int maxSizeInChars) {
            this.maxSizeInChars = maxSizeInChars;
        }

        @Override
        public StringBuilder initialValue() {
            return new StringBuilder();
        }

        public synchronized boolean isFull() {
            return ((StringBuilder)this.get()).length() >= this.maxSizeInChars;
        }

        public void clear() {
            this.set(new StringBuilder());
        }
    }
}

