/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.services.crashreport;

import com.calpano.common.server.TrackedRuntimeException;
import com.calpano.common.server.services.crashreport.ClientErrorResource;
import com.calpano.common.server.services.crashreport.ISendErrorMailService;
import com.calpano.common.server.services.crashreport.RequestLogTool;
import com.calpano.common.server.util.ExceptionUtils;
import com.calpano.common.shared.mail.Mail;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xydra.conf.annotations.RequireConfInstance;
import org.xydra.env.Env;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.IRestlessContext;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessExceptionHandler;
import org.xydra.restless.utils.HtmlUtils;
import org.xydra.restless.utils.SharedHtmlUtils;
import org.xydra.sharedutils.ReflectionUtils;

@RequireConfInstance(value={ISendErrorMailService.class})
public class SimpleRestlessExceptionHandler
implements RestlessExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(SimpleRestlessExceptionHandler.class);
    private final boolean onAppEngine;
    private final int redirectTimeMs;

    public static void logAndTrackExceptionInGoogleAnalytics(Throwable t, String requestIdentifier) {
        String action = t.getClass().getName();
        if (t instanceof TrackedRuntimeException) {
            action = ((TrackedRuntimeException)t).getTraceKey();
        }
        log.error("Restless error on request " + requestIdentifier + " : " + t.getMessage() + " GA?category=error&action=" + action, t);
    }

    public static void mailErrorToAdmins(Throwable t, String requestIdentifier, HttpServletRequest req, StringBuilder serverLogs) {
        ISendErrorMailService mailService = (ISendErrorMailService)Env.get().conf().resolve(ISendErrorMailService.class);
        Mail mail = mailService.createMailToAdmins("ServerError", t.getClass().getName() + " " + t.getMessage());
        StringBuilder buf = new StringBuilder();
        buf.append("Error. Stacktrace:<br/>");
        buf.append(ExceptionUtils.toHtmlStringWithStacktrace(t));
        buf.append("<b>Data</b><br/>\n");
        Map<String, String> dataMap = ClientErrorResource.createDataMap(requestIdentifier, req);
        buf.append(SharedHtmlUtils.toDefinitionList(dataMap));
        buf.append("=== server logs ===<br/>\n");
        buf.append((CharSequence)serverLogs);
        mail.messageTextHtml = buf.toString();
        mailService.sendMail(mail, true, false);
    }

    public SimpleRestlessExceptionHandler(boolean onAppEngine, int redirectTimeMs, Restless restless) {
        this.onAppEngine = onAppEngine;
        this.redirectTimeMs = redirectTimeMs;
        RequestLogTool.start(restless);
    }

    public boolean handleException(Throwable t, IRestlessContext context) {
        SimpleRestlessExceptionHandler.logAndTrackExceptionInGoogleAnalytics(t, context.getRequestIdentifier());
        SimpleRestlessExceptionHandler.mailErrorToAdmins(t, context.getRequestIdentifier(), context.getRequest(), RequestLogTool.getLog());
        try {
            boolean errorDisplayed = false;
            if (context.getResponse().getContentType() == null && !context.getResponse().isCommitted()) {
                try {
                    Writer w = HtmlUtils.startHtmlPage((HttpServletResponse)context.getResponse(), (int)500, (String)"Ooops", (SharedHtmlUtils.HeadChild[])new SharedHtmlUtils.HeadChild[0]);
                    w.write("<h2>An internal error occurred. The administrators have been informed.</h2>");
                    w.write(HtmlUtils.scriptRedirect((String)"", (int)this.redirectTimeMs));
                    w.write("<div>Try reloading this page or look at http://status.calpano.com</div>");
                    HtmlUtils.endHtmlPage((Writer)w);
                    errorDisplayed = true;
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
            }
            if (!errorDisplayed) {
                HtmlUtils.writeInTheMiddleOfAResponse((Writer)context.getResponse().getWriter(), (String)("<h2 style='word-break:initial;'>An error occurred.<br/>The administrators have been informed.</h2><br/><div style='color:#aaa'>Error details (already sent to admins): <br/>" + t.getClass().getCanonicalName() + " " + t.getMessage() + " " + ReflectionUtils.firstNLines((Throwable)t, (int)10) + "</div>"), (String)"", (int)this.redirectTimeMs);
            }
        }
        catch (IOException e) {
            log.warn("Could not redirect user on error", (Throwable)e);
            throw new RuntimeException(e);
        }
        return this.onAppEngine;
    }
}

