/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.tagrules;

import java.util.HashSet;

public class TagRule
implements Comparable<TagRule> {
    private final String name;
    private final HashSet<String> directImplied;
    private final HashSet<String> transitiveImplied;

    public String getName() {
        return this.name;
    }

    public HashSet<String> getDirectImplied() {
        return this.directImplied;
    }

    public HashSet<String> getTransitiveImplied() {
        return this.transitiveImplied;
    }

    public TagRule(String name, String ... implied) {
        this.name = name;
        this.directImplied = new HashSet();
        this.directImplied.add(name);
        for (String t : implied) {
            this.directImplied.add(t);
        }
        this.transitiveImplied = new HashSet<String>(this.directImplied);
    }

    public static TagRule create(String name) {
        return new TagRule(name, new String[0]);
    }

    public TagRule implies(String ... implied) {
        for (String t : implied) {
            this.addImplied(t);
        }
        return this;
    }

    private void addImplied(String implied) {
        this.directImplied.add(implied);
        this.transitiveImplied.add(implied);
    }

    @Override
    public int compareTo(TagRule o) {
        return this.getName().compareTo(o.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof TagRule && ((TagRule)o).getName().equals(this.getName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("'").append(this.getName()).append("' => ");
        for (String s : this.directImplied) {
            if (s.equals(this.getName())) continue;
            sb.append("'").append(s).append("', ");
        }
        sb.append(" =>=>=> ");
        for (String s : this.transitiveImplied) {
            if (this.directImplied.contains(s)) continue;
            sb.append("'").append(s).append("', ");
        }
        return sb.toString();
    }
}

