/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.user.wrapper;

import com.calpano.common.server.user.IServerUserService;
import com.calpano.common.shared.user.base.SharedBaseUser;
import com.calpano.common.shared.user.wrapper.ViralUser;
import java.io.UnsupportedEncodingException;
import org.xydra.base.Base;
import org.xydra.base.XId;
import org.xydra.base.id.UUID;
import org.xydra.base.rmof.XReadableModel;
import org.xydra.base.rmof.XWritableModel;
import org.xydra.conf.annotations.RequireConfInstance;
import org.xydra.core.crypto.SHA2;
import org.xydra.env.Env;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.store.session.SessionModel;

@RequireConfInstance(value={IServerUserService.class})
public class ViralManager {
    private static final Logger log = LoggerFactory.getLogger(ViralManager.class);
    private static final int ID_LENGTH = 10;
    private static String SALT = "PCikn6UM";

    public static void registerDirectSuccesor(SessionModel userModel, SharedBaseUser source, SharedBaseUser target) {
        assert (source != null);
        IServerUserService userService = (IServerUserService)Env.get().conf().getResolver(IServerUserService.class).resolve();
        ViralUser targetUser = target.asViralUser();
        assert (targetUser != null);
        if (targetUser.getNumberOfHopsFromRoot() > 0L) {
            log.info("User " + targetUser.getId() + " is already part of the viral graph (distance > 0). Connection from " + source.getId() + " ignored.");
            return;
        }
        if (targetUser.getDirectSuccessorCount() > 0L) {
            log.info("User " + targetUser.getId() + " is already part of the viral graph (has successors). Connection from " + source.getId() + " ignored.");
            return;
        }
        targetUser.setPreviousHopId(source.getId());
        ViralUser sourceHop = source.asViralUser();
        targetUser.setNumberOfHopsFromRoot(sourceHop.getNumberOfHopsFromRoot() + 1L);
        sourceHop.setDirectSuccesorCount(sourceHop.getDirectSuccessorCount() + 1L);
        sourceHop.setTotalSuccessorCount(sourceHop.getTotalSuccessorCount() + 1L);
        userModel.loadObject(sourceHop.getObjectIdToLoad());
        sourceHop.addDirectSuccessorId((XWritableModel)userModel, target.getId());
        XId previousHopId = sourceHop.getPreviousHopId();
        while (previousHopId != null) {
            SharedBaseUser previousHop = userService.getUserById(previousHopId);
            assert (previousHop != null) : previousHopId + "";
            ViralUser previousViralHop = previousHop.asViralUser();
            previousViralHop.setTotalSuccessorCount(previousViralHop.getTotalSuccessorCount() + 1L);
            previousHopId = previousViralHop.getPreviousHopId();
        }
    }

    public static XId createUniqueShortObjectId(XReadableModel model, String email) throws IllegalArgumentException {
        XId shortId = ViralManager.createShortId(email);
        if (email == null) {
            int attempts = 0;
            while (model.getObject(shortId) != null && attempts++ <= 100) {
                shortId = ViralManager.createShortId(email);
            }
            if (attempts >= 100) {
                log.error("Could not create another distinct short id, last attempt " + shortId);
            }
        } else if (model.hasObject(shortId)) {
            throw new IllegalArgumentException("email '" + email + "' has already been used ");
        }
        return shortId;
    }

    public static XId createShortId(String email) {
        if (email == null) {
            return ViralManager.toShortId(UUID.uuid((int)9, (int)62));
        }
        String s = SALT + email;
        try {
            byte[] bytes = SHA2.digest256((byte[])s.getBytes("UTF-8"));
            String hex = SHA2.bytesToHex((byte[])bytes);
            String idString = hex.substring(0, 9);
            return ViralManager.toShortId(idString);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static XId toShortId(String hex) {
        return Base.toId((String)("s" + hex));
    }
}

