/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.util;

import de.xam.p13n.shared.Personalisation;
import de.xam.velocity.AbstractVelocitySupport;
import de.xam.velocity.IVelocitySupport;
import de.xam.velocity.VelocityManager;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.velocity.Template;
import org.apache.velocity.exception.MethodInvocationException;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class CssTemplateCompiler
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(CssTemplateCompiler.class);
    private final File templateDir;
    private final File targetDirFile;
    private final String targetExt;
    private final String srcExt;
    private final String templateName;
    public static final String[] mavenSrcPath = new String[]{"/src/main/java", "/src/main/resources", "/src/test/java", "/src/test/resources"};

    public CssTemplateCompiler(String templateDir, String templateName, String srcExt, String targetDirPath, String targetExt) {
        this.templateDir = new File(templateDir);
        this.templateName = templateName;
        this.srcExt = srcExt;
        this.targetDirFile = new File(targetDirPath);
        this.targetExt = targetExt;
    }

    public static void compile(String srcFilePath, String targetFilePath) throws IOException {
        CssTemplateCompiler.compile(new File(srcFilePath), new File(targetFilePath));
    }

    public static void compileForMojo(File cssTemplate, File targetDir) throws IOException {
        String baseName = FilenameUtils.getBaseName((String)cssTemplate.getName());
        File targetFile = new File(targetDir, baseName + ".css");
        CssTemplateCompiler.compile(cssTemplate, targetFile);
    }

    public static void compile(File srcFile, File targetFile) throws IOException, MethodInvocationException {
        File targetDir = targetFile.getParentFile();
        if (!targetDir.exists()) {
            throw new RuntimeException("Target dir not found '" + targetDir.getAbsolutePath() + "'");
        }
        String rootPath = null;
        for (String mavenSourcePath : mavenSrcPath) {
            String srcPath = srcFile.getAbsolutePath();
            int i = srcPath.indexOf(mavenSourcePath);
            if (i < 0) continue;
            rootPath = srcPath.substring(0, i + mavenSourcePath.length());
        }
        assert (rootPath != null) : "Could not find root path for srcFile '" + srcFile.getAbsolutePath() + "'";
        CssTemplateCompiler.waitASecond();
        VelocityManager vm = new VelocityManager(new File(rootPath));
        AbstractVelocitySupport velocity = new AbstractVelocitySupport(Personalisation.DEFAULT){

            public String[] getMessagePackages() {
                return null;
            }

            public Object getDataForContext() {
                return null;
            }
        };
        Template velocityTemplate = vm.loadTemplateFromFile(new File(rootPath), srcFile);
        Map dataMap = vm.toMap((IVelocitySupport)velocity);
        StringWriter sw = new StringWriter();
        try {
            vm.writeTo(velocityTemplate, dataMap, (Writer)sw, false);
            sw.close();
        }
        catch (Exception e) {
            log.warn("Error when processing '" + srcFile.getAbsolutePath() + "'", (Throwable)e);
            sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.close();
            sw.close();
        }
        String generated = sw.getBuffer().toString();
        int hash = generated.hashCode();
        generated = "/* Generated on " + System.currentTimeMillis() + " hash " + hash + " */\n" + generated;
        log.info("Writing version '" + hash + "' to" + targetFile.getAbsolutePath());
        FileUtils.writeStringToFile((File)targetFile, (String)generated);
    }

    private static void waitASecond() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            log.warn("sleep", (Throwable)e);
        }
    }

    @Override
    public void run() {
        File srcFile = new File(this.templateDir, this.templateName + "." + this.srcExt);
        String baseName = FilenameUtils.getBaseName((String)srcFile.getName());
        File targetFile = new File(this.targetDirFile, baseName + "." + this.targetExt);
        try {
            CssTemplateCompiler.compile(srcFile, targetFile);
        }
        catch (IOException e) {
            log.warn("IO!", (Throwable)e);
        }
    }

    public String getTemplateDir() {
        return this.templateDir.getAbsolutePath();
    }

    public String getTemplateExt() {
        return this.srcExt;
    }
}

