/*
 * Decompiled with CFR 0.152.
 */
package org.jukito;

import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scope;
import com.google.inject.spi.BindingScopingVisitor;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.ConvertedConstantBinding;
import com.google.inject.spi.DefaultBindingScopingVisitor;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Elements;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.Message;
import com.google.inject.spi.ProviderBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderKeyBinding;
import com.google.inject.spi.UntargettedBinding;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingsCollector {
    private final AbstractModule module;
    private final List<BindingInfo> bindingsObserved = new ArrayList<BindingInfo>();
    private final List<Message> messages = new ArrayList<Message>();

    BindingsCollector(AbstractModule module) {
        this.module = module;
    }

    public void collectBindings() {
        GuiceElementVisitor visitor = new GuiceElementVisitor();
        visitor.visitElements(Elements.getElements((Module[])new Module[]{this.module}));
    }

    public List<BindingInfo> getBindingsObserved() {
        return this.bindingsObserved;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GuiceScopingVisitor
    extends DefaultBindingScopingVisitor<String> {
        public String visitEagerSingleton() {
            return "EagerSingleton";
        }

        public String visitScope(Scope scope) {
            return scope.toString();
        }

        public String visitScopeAnnotation(Class<? extends Annotation> scopeAnnotation) {
            return scopeAnnotation.getCanonicalName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GuiceBindingVisitor<T>
    extends DefaultBindingTargetVisitor<T, Void> {
        private Void addBindingInfo(Binding<? extends T> binding, Key<?> boundKey, Object instance) {
            BindingsCollector.this.bindingsObserved.add(BindingInfo.create(binding, boundKey, instance));
            return null;
        }

        private Void addBinding(Binding<? extends T> binding) {
            return this.addBindingInfo(binding, binding.getKey(), null);
        }

        private Void addBindingKey(Binding<? extends T> binding, Key<?> boundKey) {
            return this.addBindingInfo(binding, boundKey, null);
        }

        private Void addBindingInstance(Binding<? extends T> binding, Object instance) {
            return this.addBindingInfo(binding, null, instance);
        }

        public Void visit(ProviderBinding<? extends T> providerBinding) {
            return this.addBindingKey((Binding<? extends T>)providerBinding, (Key<?>)providerBinding.getProvidedKey());
        }

        public Void visit(ProviderKeyBinding<? extends T> providerKeyBinding) {
            return this.addBindingKey((Binding<? extends T>)providerKeyBinding, (Key<?>)providerKeyBinding.getProviderKey());
        }

        public Void visit(ProviderInstanceBinding<? extends T> providerInstanceBinding) {
            return this.addBindingInstance((Binding<? extends T>)providerInstanceBinding, providerInstanceBinding.getProviderInstance());
        }

        public Void visit(InstanceBinding<? extends T> instanceBinding) {
            return this.addBindingInstance((Binding<? extends T>)instanceBinding, instanceBinding.getInstance());
        }

        public Void visit(ConvertedConstantBinding<? extends T> constantBinding) {
            return this.addBindingInstance((Binding<? extends T>)constantBinding, constantBinding.getValue());
        }

        public Void visit(UntargettedBinding<? extends T> untargettedBinding) {
            return this.addBinding((Binding<? extends T>)untargettedBinding);
        }

        public Void visit(LinkedKeyBinding<? extends T> linkedKeyBinding) {
            return this.addBindingKey((Binding<? extends T>)linkedKeyBinding, (Key<?>)linkedKeyBinding.getLinkedKey());
        }

        public Void visit(ConstructorBinding<? extends T> constructorBinding) {
            return this.addBinding((Binding<? extends T>)constructorBinding);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GuiceElementVisitor
    extends DefaultElementVisitor<Void> {
        private void visitElements(List<Element> elements) {
            for (Element element : elements) {
                element.acceptVisitor((ElementVisitor)this);
            }
        }

        public <T> Void visit(Binding<T> command) {
            GuiceBindingVisitor bindingVisitor = new GuiceBindingVisitor();
            command.acceptTargetVisitor(bindingVisitor);
            return null;
        }

        public Void visit(Message message) {
            BindingsCollector.this.messages.add(message);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BindingInfo {
        Key<?> key;
        Key<?> boundKey;
        public Object boundInstance;
        String scope;

        public static BindingInfo create(Binding<?> binding, Key<?> boundKey, Object instance) {
            BindingInfo bindingInfo = new BindingInfo();
            bindingInfo.key = binding.getKey();
            bindingInfo.boundKey = boundKey;
            bindingInfo.boundInstance = instance;
            bindingInfo.scope = (String)binding.acceptScopingVisitor((BindingScopingVisitor)new GuiceScopingVisitor());
            return bindingInfo;
        }
    }
}

