/*
 * Decompiled with CFR 0.152.
 */
package org.jukito;

import com.google.inject.ConfigurationException;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Annotations;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ErrorsException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceUtils {
    public static boolean isProvider(Key<?> key) {
        return key.getTypeLiteral().getRawType().equals(Provider.class);
    }

    public static <T> TypeLiteral<T> getProvidedType(TypeLiteral<? extends Provider<? extends T>> initialProviderTypeLiteral, Errors errors) throws ErrorsException {
        TypeLiteral providerTypeLiteral = initialProviderTypeLiteral;
        while (providerTypeLiteral.getRawType() != Provider.class) {
            providerTypeLiteral = providerTypeLiteral.getSupertype(Provider.class);
        }
        Type providerType = providerTypeLiteral.getType();
        if (!(providerType instanceof ParameterizedType)) {
            throw errors.cannotInjectRawProvider().toException();
        }
        Type entryType = ((ParameterizedType)providerType).getActualTypeArguments()[0];
        return TypeLiteral.get((Type)entryType);
    }

    public static <T> Key<T> getProvidedKey(Key<Provider<T>> key, Errors errors) throws ErrorsException {
        TypeLiteral<T> providedType = GuiceUtils.getProvidedType(key.getTypeLiteral(), errors);
        Key providedKey = key.getAnnotation() == null ? Key.get(providedType) : Key.get(providedType, (Annotation)key.getAnnotation());
        return providedKey;
    }

    public static <T> Key<T> ensureProvidedKey(Key<T> key, Errors errors) {
        try {
            return GuiceUtils.isProvider(key) ? GuiceUtils.getProvidedKey(key, errors) : key;
        }
        catch (ConfigurationException e) {
            errors.merge(e.getErrorMessages());
        }
        catch (ErrorsException e) {
            errors.merge(e.getErrors());
        }
        return null;
    }

    public static List<Key<?>> getMethodKeys(Method method, Errors errors) {
        Annotation[][] allParameterAnnotations = method.getParameterAnnotations();
        ArrayList result = new ArrayList(allParameterAnnotations.length);
        Iterator annotationsIterator = Arrays.asList(allParameterAnnotations).iterator();
        TypeLiteral type = TypeLiteral.get(method.getDeclaringClass());
        for (TypeLiteral parameterType : type.getParameterTypes((Member)method)) {
            try {
                Annotation[] parameterAnnotations = (Annotation[])annotationsIterator.next();
                result.add(Annotations.getKey((TypeLiteral)parameterType, (Member)method, (Annotation[])parameterAnnotations, (Errors)errors));
            }
            catch (ConfigurationException e) {
                errors.merge(e.getErrorMessages());
            }
            catch (ErrorsException e) {
                errors.merge(e.getErrors());
            }
        }
        return result;
    }
}

