/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.guice;

import com.google.gwt.core.client.GWT;
import com.google.inject.Injector;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.servlet.ServletDefinitionReader;
import com.googlecode.gwt.test.exceptions.GwtTestConfigurationException;
import com.googlecode.gwt.test.internal.utils.WebXmlUtils;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GwtGuiceHelper {
    private static final GwtGuiceHelper INSTANCE = new GwtGuiceHelper();
    private boolean hasSearchedInjector = false;
    private Injector injector;
    private ServletDefinitionReader servletDefinitionReader;

    public static GwtGuiceHelper get() {
        return INSTANCE;
    }

    private GwtGuiceHelper() {
    }

    public Injector getInjector() {
        if (this.injector == null && !this.hasSearchedInjector) {
            for (String listenerClassName : WebXmlUtils.get().getListenerClasses()) {
                try {
                    Class<?> clazz = GwtReflectionUtils.getClass(listenerClassName);
                    if (!GuiceServletContextListener.class.isAssignableFrom(clazz)) continue;
                    Object instance = GwtReflectionUtils.instantiateClass(clazz);
                    this.injector = (Injector)GwtReflectionUtils.callPrivateMethod(instance, "getInjector", new Object[0]);
                }
                catch (Exception e) {
                    throw new GwtTestConfigurationException("Error while parsing web.xml searching for a Guice Injector in a configured GuiceServletContextListener", e);
                }
            }
            this.hasSearchedInjector = true;
        }
        return this.injector;
    }

    public Object getRpcServiceFromInjector(Injector injector, Class<?> remoteServiceClass, String remoteServiceRelativePath) {
        if (this.servletDefinitionReader == null) {
            this.servletDefinitionReader = new ServletDefinitionReader(injector);
        }
        String moduleName = GWT.getModuleName();
        return this.servletDefinitionReader.getServletForPath("/" + moduleName + "/" + remoteServiceRelativePath);
    }
}

