/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal;

import com.googlecode.gwt.test.exceptions.GwtTestPatchException;
import com.googlecode.gwt.test.internal.ConfigurationLoader;
import java.lang.reflect.Modifier;
import java.net.URLClassLoader;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.Loader;
import javassist.NotFoundException;
import javassist.Translator;

class CompilationStateClassLoader
extends Loader {
    CompilationStateClassLoader(ClassLoader parent, ConfigurationLoader configurationLoader) {
        super((ClassLoader)new URLClassLoader(configurationLoader.getSrcUrls(), parent), null);
        ClassPool cp = new ClassPool(null);
        cp.appendSystemPath();
        for (String delegate : configurationLoader.getDelegates()) {
            this.delegateLoadingOf(delegate);
        }
        try {
            this.addTranslator(cp, new MakeClassPublicTranslator());
        }
        catch (Exception e) {
            throw new GwtTestPatchException("Error while trying to setup the temporary classloader to load GWT generated .java files", e);
        }
    }

    private class MakeClassPublicTranslator
    implements Translator {
        private MakeClassPublicTranslator() {
        }

        public void onLoad(ClassPool pool, String classname) throws NotFoundException, CannotCompileException {
            CtClass ctClass = pool.get(classname);
            int modifiers = ctClass.getModifiers();
            if (!Modifier.isPublic(modifiers)) {
                ctClass.setModifiers(modifiers + 1);
            }
        }

        public void start(ClassPool pool) throws NotFoundException, CannotCompileException {
        }
    }
}

