/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal;

import com.googlecode.gwt.test.exceptions.GwtTestConfigurationException;
import com.googlecode.gwt.test.exceptions.GwtTestException;
import com.googlecode.gwt.test.exceptions.GwtTestPatchException;
import com.googlecode.gwt.test.internal.ClassesScanner;
import com.googlecode.gwt.test.internal.PatcherFactory;
import com.googlecode.gwt.test.internal.SrcDirectoriesHolder;
import com.googlecode.gwt.test.patchers.PatchClass;
import com.googlecode.gwt.test.utils.JavassistUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javassist.CtClass;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigurationLoader {
    private static final String CONFIG_FILENAME = "META-INF/gwt-test-utils.properties";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationLoader.class);
    private final Set<String> delegates;
    private final List<String> gwtModules = new ArrayList<String>();
    private PatcherFactory patcherFactory;
    private final Set<String> scanPackages;
    private final List<URL> srcDirectories;

    ConfigurationLoader(URL surefireBooterJarUrl) {
        this.delegates = new HashSet<String>();
        this.scanPackages = new HashSet<String>();
        this.srcDirectories = new ArrayList<URL>();
        this.readFiles();
        this.visitPatchClasses();
        this.processRelatedProjectSrcDirectories(surefireBooterJarUrl);
    }

    public Set<String> getDelegates() {
        return this.delegates;
    }

    public List<String> getGwtModules() {
        return this.gwtModules;
    }

    public PatcherFactory getPatcherFactory() {
        return this.patcherFactory;
    }

    public Set<String> getScanPackages() {
        return this.scanPackages;
    }

    public URL[] getSrcUrls() {
        return this.srcDirectories.toArray(new URL[this.srcDirectories.size()]);
    }

    private void addToSrcUrls(File file) {
        try {
            this.srcDirectories.add(file.toURI().toURL());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void collectEventualSourceDirectories(File classpathEntry, int distance, int currentLevel) {
        String projectRootPath = classpathEntry.getAbsolutePath();
        for (String srcDir : SrcDirectoriesHolder.SRC_DIRECTORIES) {
            File file;
            StringBuilder sb = new StringBuilder(projectRootPath).append("/").append(srcDir);
            if (!srcDir.endsWith("/")) {
                sb.append("/");
            }
            if (!(file = new File(sb.toString())).exists()) continue;
            this.addToSrcUrls(file);
        }
        if (currentLevel < distance) {
            this.collectEventualSourceDirectories(classpathEntry.getParentFile(), distance, ++currentLevel);
        }
    }

    private URL[] extractSrcUrlsFromBooterJar(String surefireBooterJarPath) {
        try {
            JarFile surefireBooterJar = new JarFile(surefireBooterJarPath);
            Manifest mf = surefireBooterJar.getManifest();
            Attributes a = mf.getMainAttributes();
            String[] classpathEntries = a.getValue("Class-Path").split(" ");
            URL[] urls = new URL[classpathEntries.length];
            for (int i = 0; i < classpathEntries.length; ++i) {
                urls[i] = new URL(classpathEntries[i]);
            }
            return urls;
        }
        catch (Exception e) {
            throw new GwtTestException("Error while parsing maven-surefire-plugin booter jar: " + surefireBooterJarPath, e);
        }
    }

    private void process(Properties p, URL url) {
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String key = ((String)entry.getKey()).trim();
            String value = ((String)entry.getValue()).trim();
            if ("gwt-module".equals(value)) {
                this.gwtModules.add(key);
                continue;
            }
            if ("scan-package".equals(value)) {
                this.scanPackages.add(key);
                continue;
            }
            if ("delegate".equals(value)) {
                this.delegates.add(key);
                continue;
            }
            if ("src-directory".equals(value)) {
                this.processSrcDirectory(key);
                continue;
            }
            throw new GwtTestConfigurationException("Error in '" + url.getPath() + "' : unknown value '" + value + "'");
        }
        if (this.gwtModules.size() == 0) {
            throw new GwtTestConfigurationException("No declared module. Did you forget to add your own META-INF/gwt-test-utils.properties file with a 'gwt-module' property in the test classpath?");
        }
    }

    private void processRelatedProjectSrcDirectories(URL surefireBooterJarUrl) {
        URL[] classpathUrls = null;
        if (surefireBooterJarUrl != null) {
            classpathUrls = this.extractSrcUrlsFromBooterJar(surefireBooterJarUrl.getFile());
        } else {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader instanceof URLClassLoader) {
                classpathUrls = ((URLClassLoader)classLoader).getURLs();
            }
        }
        if (classpathUrls == null) {
            throw new GwtTestConfigurationException("Unable to collect classpath entries");
        }
        for (URL classpathUrl : classpathUrls) {
            this.srcDirectories.add(classpathUrl);
            if (classpathUrl.getPath().endsWith(".jar")) continue;
            try {
                this.collectEventualSourceDirectories(new File(classpathUrl.toURI()), 2, 0);
            }
            catch (URISyntaxException e) {
                throw new GwtTestConfigurationException("Error while getting source folder(s) related to path " + classpathUrl.getPath(), e);
            }
        }
    }

    private void processSrcDirectory(String srcDir) {
        SrcDirectoriesHolder.SRC_DIRECTORIES.add(srcDir);
    }

    private void readFiles() {
        try {
            Enumeration<URL> configFiles = Thread.currentThread().getContextClassLoader().getResources(CONFIG_FILENAME);
            while (configFiles.hasMoreElements()) {
                URL url = configFiles.nextElement();
                LOGGER.debug("Load config file " + url.toString());
                Properties p = new Properties();
                InputStream inputStream = url.openStream();
                p.load(inputStream);
                inputStream.close();
                this.process(p, url);
                LOGGER.debug("File loaded and processed " + url.toString());
            }
        }
        catch (IOException e) {
            throw new GwtTestConfigurationException("Error while reading 'META-INF/gwt-test-utils.properties' files", e);
        }
    }

    private void visitPatchClasses() {
        final HashMap<String, Set<CtClass>> patchClassMap = new HashMap<String, Set<CtClass>>();
        ClassesScanner.ClassVisitor patchClassVisitor = new ClassesScanner.ClassVisitor(){

            public void visit(CtClass ctClass) {
                try {
                    if (ctClass.hasAnnotation(PatchClass.class)) {
                        Annotation annotation = JavassistUtils.getAnnotation(ctClass, PatchClass.class);
                        String classToPatchName = PatchClass.class.getName();
                        ClassMemberValue value = (ClassMemberValue)annotation.getMemberValue("value");
                        if (value != null) {
                            classToPatchName = value.getValue();
                        }
                        if (classToPatchName.equals(PatchClass.class.getName())) {
                            StringMemberValue target = (StringMemberValue)annotation.getMemberValue("target");
                            String string = classToPatchName = target != null ? target.getValue() : "";
                        }
                        if (!"".equals(classToPatchName)) {
                            this.addPatchClass(classToPatchName, ctClass);
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new GwtTestPatchException(e);
                }
            }

            private void addPatchClass(String targetName, CtClass patchClass) {
                HashSet<CtClass> patchClasses = (HashSet<CtClass>)patchClassMap.get(targetName);
                if (patchClasses == null) {
                    patchClasses = new HashSet<CtClass>();
                    patchClassMap.put(targetName, patchClasses);
                }
                patchClasses.add(patchClass);
                LOGGER.debug("Add patch for class '" + targetName + "' : '" + patchClass.getName() + "'");
            }
        };
        ClassesScanner.getInstance().scanPackages(patchClassVisitor, this.scanPackages);
        this.patcherFactory = new PatcherFactory(patchClassMap);
    }
}

