/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal;

import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.HasText;
import com.googlecode.gwt.test.finder.GwtFinder;
import com.googlecode.gwt.test.internal.GwtClassPool;
import com.googlecode.gwt.test.internal.JavaClassModifier;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;

class HasHTMLModifier
implements JavaClassModifier {
    private final CtClass hasHTMLCtClass;
    private final CtClass hasTextCtClass = GwtClassPool.getCtClass(HasText.class);
    private final CtClass[] setArgs;

    HasHTMLModifier() {
        this.hasHTMLCtClass = GwtClassPool.getCtClass(HasHTML.class);
        this.setArgs = new CtClass[]{GwtClassPool.getCtClass(String.class)};
    }

    public void modify(CtClass classToModify) throws Exception {
        if (classToModify.isInterface()) {
            return;
        }
        if (classToModify.subtypeOf(this.hasHTMLCtClass)) {
            this.instrumentSetText(classToModify);
            this.instrumentSetHTML(classToModify);
        } else if (classToModify.subtypeOf(this.hasTextCtClass)) {
            this.instrumentSetText(classToModify);
        }
    }

    private void addHTMLField(CtClass c) throws CannotCompileException {
        CtField oldHTMLField = CtField.make((String)"protected String instrument_oldHTML;", (CtClass)c);
        c.addField(oldHTMLField);
    }

    private void addTextField(CtClass c) throws CannotCompileException {
        CtField oldTextField = CtField.make((String)"protected String instrument_oldText;", (CtClass)c);
        c.addField(oldTextField);
    }

    private void instrumentSetHTML(CtClass c) throws CannotCompileException {
        try {
            CtMethod setHTML = c.getDeclaredMethod("setHTML", this.setArgs);
            this.addHTMLField(c);
            setHTML.insertBefore("this.instrument_oldHTML = this.getHTML();");
            setHTML.insertAfter(GwtFinder.class.getName() + ".onSetHTML(this, $1, this.instrument_oldHTML);");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void instrumentSetText(CtClass c) throws CannotCompileException {
        try {
            CtMethod setText = c.getDeclaredMethod("setText", this.setArgs);
            this.addTextField(c);
            setText.insertBefore("this.instrument_oldText = this.getText();");
            setText.insertAfter(GwtFinder.class.getName() + ".onSetText(this, $1, this.instrument_oldText);");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }
}

