/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.handlers;

import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.dev.RebindCache;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.dev.cfg.Rules;
import com.google.gwt.dev.javac.CompilationState;
import com.google.gwt.dev.javac.StandardGeneratorContext;
import com.google.gwt.dev.shell.ArtifactAcceptor;
import com.google.gwt.dev.shell.CompilingClassLoader;
import com.google.gwt.dev.shell.ModuleSpace;
import com.google.gwt.dev.shell.ModuleSpaceHost;
import com.google.gwt.dev.shell.ModuleSpacePropertyOracle;
import com.google.gwt.dev.shell.StandardRebindOracle;
import com.google.gwt.dev.util.log.speedtracer.DevModeEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import java.io.File;

class GwtTestModuleSpaceHost
implements ModuleSpaceHost {
    private static final Object rebindLock = new Object[0];
    protected final CompilationState compilationState;
    protected final File genDir;
    private final ArtifactAcceptor artifactAcceptor;
    private final TreeLogger logger;
    private final ModuleDef module;
    private final RebindCache rebindCache;
    private StandardRebindOracle rebindOracle;
    private ModuleSpace space;

    public GwtTestModuleSpaceHost(TreeLogger logger, CompilationState compilationState, ModuleDef module, File genDir, ArtifactAcceptor artifactAcceptor, RebindCache rebindCache) {
        this.logger = logger;
        this.compilationState = compilationState;
        this.module = module;
        this.genDir = genDir;
        this.artifactAcceptor = artifactAcceptor;
        this.rebindCache = rebindCache;
    }

    public CompilingClassLoader getClassLoader() {
        return null;
    }

    public String[] getEntryPointTypeNames() {
        this.checkForModuleSpace();
        return this.module.getEntryPointTypeNames();
    }

    public TreeLogger getLogger() {
        return this.logger;
    }

    public void invalidateRebind(String sourceTypeName) {
        this.checkForModuleSpace();
        this.rebindOracle.invalidateRebind(sourceTypeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onModuleReady(ModuleSpace readySpace) throws UnableToCompleteException {
        this.space = readySpace;
        SpeedTracerLogger.Event moduleSpaceHostReadyEvent = SpeedTracerLogger.start((SpeedTracerLogger.EventType)DevModeEventType.MODULE_SPACE_HOST_READY, (String[])new String[0]);
        try {
            ModuleSpacePropertyOracle propOracle = new ModuleSpacePropertyOracle(this.module.getProperties(), this.module.getActiveLinkerNames(), readySpace);
            Rules rules = this.module.getRules();
            StandardGeneratorContext genCtx = new StandardGeneratorContext(this.compilationState, this.module, this.genDir, new ArtifactSet(), false);
            genCtx.setGeneratorResultCachingEnabled(this.rebindCache != null);
            this.rebindOracle = new StandardRebindOracle((PropertyOracle)propOracle, rules, genCtx);
            this.rebindOracle.setRebindCache(this.rebindCache);
        }
        finally {
            moduleSpaceHostReadyEvent.end(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String rebind(TreeLogger logger, String sourceTypeName) throws UnableToCompleteException {
        Object object = rebindLock;
        synchronized (object) {
            this.checkForModuleSpace();
            return this.rebindOracle.rebind(logger, sourceTypeName, new ArtifactAcceptor(){

                public void accept(TreeLogger logger, ArtifactSet newlyGeneratedArtifacts) throws UnableToCompleteException {
                    GwtTestModuleSpaceHost.this.artifactAcceptor.accept(logger, newlyGeneratedArtifacts);
                }
            });
        }
    }

    private void checkForModuleSpace() {
        if (this.space == null) {
            throw new IllegalStateException("Module initialization error");
        }
    }
}

