/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.patchers.dom;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.ButtonElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.OptionElement;
import com.google.gwt.dom.client.SelectElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.Text;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.googlecode.gwt.test.internal.patchers.dom.SelectElementPatcher;
import com.googlecode.gwt.test.internal.utils.EventUtils;
import com.googlecode.gwt.test.internal.utils.GwtStyleUtils;
import com.googlecode.gwt.test.internal.utils.JsoUtils;
import com.googlecode.gwt.test.internal.utils.PropertyContainer;
import com.googlecode.gwt.test.patchers.PatchClass;
import com.googlecode.gwt.test.patchers.PatchMethod;
import com.googlecode.gwt.test.utils.JavaScriptObjects;
import com.googlecode.gwt.test.utils.events.EventBuilder;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PatchClass(target="com.google.gwt.dom.client.DOMImpl")
class DOMImplPatcher {
    private static final String SCROLL_LEFT = "scrollLeft";
    private static final String TAB_INDEX = "tabIndex";

    DOMImplPatcher() {
    }

    @PatchMethod
    static void buttonClick(Object domImpl, ButtonElement button) {
        EventTarget relatedTarget = (EventTarget)button.cast();
        Event onMouseOver = EventBuilder.create(16).setTarget((Element)button).setRelatedTarget(relatedTarget).build();
        DOMImplPatcher.dispatchEvent(domImpl, (Element)button, (NativeEvent)onMouseOver);
        Event onMouseDown = EventBuilder.create(4).setTarget((Element)button).setRelatedTarget(relatedTarget).setButton(1).build();
        DOMImplPatcher.dispatchEvent(domImpl, (Element)button, (NativeEvent)onMouseDown);
        Event onMouseUp = EventBuilder.create(8).setTarget((Element)button).setRelatedTarget(relatedTarget).setButton(1).build();
        DOMImplPatcher.dispatchEvent(domImpl, (Element)button, (NativeEvent)onMouseUp);
        Event onClick = EventBuilder.create(1).setTarget((Element)button).setRelatedTarget(relatedTarget).build();
        DOMImplPatcher.dispatchEvent(domImpl, (Element)button, (NativeEvent)onClick);
    }

    @PatchMethod
    static ButtonElement createButtonElement(Object domImpl, Document doc, String type) {
        ButtonElement e = (ButtonElement)doc.createElement("button").cast();
        e.setAttribute("type", type);
        return e;
    }

    @PatchMethod
    static InputElement createCheckInputElement(Object domImpl, Document doc) {
        InputElement e = DOMImplPatcher.createInputElement(doc, "checkbox", null);
        e.setValue("on");
        return e;
    }

    @PatchMethod
    static Element createElement(Object domImpl, Document doc, String tag) {
        return JsoUtils.newElement(tag, doc);
    }

    @PatchMethod
    static NativeEvent createHtmlEvent(Object domImpl, Document doc, String type, boolean canBubble, boolean cancelable) {
        int typeInt = EventUtils.getEventTypeInt(type);
        return EventBuilder.create(typeInt).setCanBubble(canBubble).build();
    }

    @PatchMethod
    static InputElement createInputElement(Object domImpl, Document doc, String type) {
        return DOMImplPatcher.createInputElement(doc, type, null);
    }

    @PatchMethod
    static InputElement createInputRadioElement(Object domImpl, Document doc, String name) {
        return DOMImplPatcher.createInputElement(doc, "RADIO", name);
    }

    @PatchMethod
    static NativeEvent createKeyCodeEvent(Object domImpl, Document document, String type, boolean ctrlKey, boolean altKey, boolean shiftKey, boolean metaKey, int keyCode) {
        int typeInt = EventUtils.getEventTypeInt(type);
        return EventBuilder.create(typeInt).setCtrlKey(ctrlKey).setAltKey(altKey).setShiftKey(shiftKey).setMetaKey(metaKey).setKeyCode(keyCode).build();
    }

    @PatchMethod
    static NativeEvent createKeyPressEvent(Object domImpl, Document document, boolean ctrlKey, boolean altKey, boolean shiftKey, boolean metaKey, int charCode) {
        return EventBuilder.create(256).setCtrlKey(ctrlKey).setAltKey(altKey).setShiftKey(shiftKey).setMetaKey(metaKey).setKeyCode(charCode).build();
    }

    @PatchMethod
    static NativeEvent createMouseEvent(Object domImpl, Document doc, String type, boolean canBubble, boolean cancelable, int detail, int screenX, int screenY, int clientX, int clientY, boolean ctrlKey, boolean altKey, boolean shiftKey, boolean metaKey, int button, Element relatedTarget) {
        int typeInt = EventUtils.getEventTypeInt(type);
        return EventBuilder.create(typeInt).setCtrlKey(ctrlKey).setAltKey(altKey).setShiftKey(shiftKey).setMetaKey(metaKey).setButton(button).setTarget(relatedTarget).build();
    }

    @PatchMethod
    static void cssClearOpacity(Object domImpl, Style style) {
        style.setProperty("opacity", "");
    }

    @PatchMethod
    static void cssSetOpacity(Object domImpl, Style style, double value) {
        double modulo = value % 1.0;
        String stringValue = modulo == 0.0 ? String.valueOf((int)value) : String.valueOf(value);
        style.setProperty("opacity", stringValue);
    }

    @PatchMethod
    static void dispatchEvent(Object domImpl, Element target, NativeEvent evt) {
        EventListener listener = DOM.getEventListener((com.google.gwt.user.client.Element)((com.google.gwt.user.client.Element)target.cast()));
        if (listener != null && evt instanceof Event) {
            listener.onBrowserEvent((Event)evt);
        }
        boolean propagationStopped = JavaScriptObjects.getBoolean((JavaScriptObject)evt, "EVENT_isStopped");
        if (target.getParentElement() != null && propagationStopped) {
            target.getParentElement().dispatchEvent(evt);
        }
    }

    @PatchMethod
    static boolean eventGetAltKey(Object domImpl, NativeEvent evt) {
        return JavaScriptObjects.getBoolean((JavaScriptObject)evt, "EVENT_altKey");
    }

    @PatchMethod
    static int eventGetButton(Object domImpl, NativeEvent evt) {
        return JavaScriptObjects.getInteger((JavaScriptObject)evt, "EVENT_button");
    }

    @PatchMethod
    static int eventGetCharCode(Object domImpl, NativeEvent evt) {
        return evt.getKeyCode();
    }

    @PatchMethod
    static int eventGetClientX(Object domImpl, NativeEvent evt) {
        return JavaScriptObjects.getInteger((JavaScriptObject)evt, "EVENT_clientX");
    }

    @PatchMethod
    static int eventGetClientY(Object domImpl, NativeEvent evt) {
        return JavaScriptObjects.getInteger((JavaScriptObject)evt, "EVENT_clientY");
    }

    @PatchMethod
    static boolean eventGetCtrlKey(Object domImpl, NativeEvent evt) {
        return JavaScriptObjects.getBoolean((JavaScriptObject)evt, "EVENT_ctrlKey");
    }

    @PatchMethod
    static int eventGetKeyCode(Object domImpl, NativeEvent evt) {
        return JavaScriptObjects.getInteger((JavaScriptObject)evt, "EVENT_keyCode");
    }

    @PatchMethod
    static boolean eventGetMetaKey(Object domImpl, NativeEvent evt) {
        return JavaScriptObjects.getBoolean((JavaScriptObject)evt, "EVENT_metaKey");
    }

    @PatchMethod
    static EventTarget eventGetRelatedTarget(Object domImpl, NativeEvent nativeEvent) {
        JavaScriptObject relatedTargetJSO = (JavaScriptObject)JavaScriptObjects.getObject((JavaScriptObject)nativeEvent, "EVENT_relatedTarget");
        if (relatedTargetJSO == null) {
            return null;
        }
        return (EventTarget)relatedTargetJSO.cast();
    }

    @PatchMethod
    static int eventGetScreenX(Object domImpl, NativeEvent evt) {
        return JavaScriptObjects.getInteger((JavaScriptObject)evt, "EVENT_screenX");
    }

    @PatchMethod
    static int eventGetScreenY(Object domImpl, NativeEvent evt) {
        return JavaScriptObjects.getInteger((JavaScriptObject)evt, "EVENT_screenY");
    }

    @PatchMethod
    static boolean eventGetShiftKey(Object domImpl, NativeEvent evt) {
        return JavaScriptObjects.getBoolean((JavaScriptObject)evt, "EVENT_shiftKey");
    }

    @PatchMethod
    static EventTarget eventGetTarget(Object domImpl, NativeEvent nativeEvent) {
        Element target = (Element)JavaScriptObjects.getObject((JavaScriptObject)nativeEvent, "EVENT_target");
        return (EventTarget)target.cast();
    }

    @PatchMethod
    static String eventGetType(Object domImpl, NativeEvent nativeEvent) {
        int eventType = JavaScriptObjects.getInteger((JavaScriptObject)nativeEvent, "EVENT_type");
        return EventUtils.getEventTypeString(eventType);
    }

    @PatchMethod
    static void eventPreventDefault(Object domImpl, NativeEvent evt) {
        JavaScriptObjects.setProperty((JavaScriptObject)evt, "EVENT_preventDefault", true);
    }

    @PatchMethod
    static void eventStopPropagation(Object domImpl, NativeEvent evt) {
        JavaScriptObjects.setProperty((JavaScriptObject)evt, "EVENT_isStopped", true);
    }

    @PatchMethod
    static int getAbsoluteLeft(Object domImpl, Element elem) {
        return 0;
    }

    @PatchMethod
    static int getAbsoluteTop(Object domImpl, Element elem) {
        return 0;
    }

    @PatchMethod
    static String getAttribute(Object domImpl, Element elem, String name) {
        if ("style".equals(name)) {
            return elem.getStyle().toString();
        }
        PropertyContainer properties = JsoUtils.getDomProperties(elem);
        String propertyName = DOMImplPatcher.getDOMPropertyName(name);
        return properties.getString(propertyName);
    }

    @PatchMethod
    static int getBodyOffsetLeft(Object domImpl, Document doc) {
        return 0;
    }

    @PatchMethod
    static int getBodyOffsetTop(Object domImpl, Document doc) {
        return 0;
    }

    static String getDOMPropertyName(String propertyNameCaseInsensitive) {
        if ("class".equals(propertyNameCaseInsensitive = propertyNameCaseInsensitive.toLowerCase())) {
            return "className";
        }
        return propertyNameCaseInsensitive;
    }

    @PatchMethod
    static Element getFirstChildElement(Object domImpl, Element elem) {
        NodeList nodeList = elem.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.getItem(i);
            if (node.getNodeType() != 1) continue;
            return (Element)node.cast();
        }
        return null;
    }

    @PatchMethod
    static String getInnerHTML(Object domImpl, Element elem) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < elem.getChildNodes().getLength(); ++i) {
            Node current = elem.getChildNodes().getItem(i);
            if (current.getNodeType() == 3) {
                Text text = (Text)current.cast();
                sb.append(text.getData());
                continue;
            }
            sb.append(current.toString());
        }
        return sb.toString();
    }

    @PatchMethod
    static String getInnerText(Object domImpl, Element elem) {
        StringBuilder sb = new StringBuilder("");
        DOMImplPatcher.appendInnerTextRecursive(elem, sb);
        return sb.toString();
    }

    @PatchMethod
    static Element getNextSiblingElement(Object domImpl, Element elem) {
        Node parent = elem.getParentNode();
        if (parent == null) {
            return null;
        }
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node current = list.getItem(i);
            if (!current.equals((Object)elem) || i >= list.getLength() - 1) continue;
            while (i < list.getLength() - 1) {
                if (list.getItem(++i).getNodeType() != 1) continue;
                return (Element)list.getItem(i).cast();
            }
        }
        return null;
    }

    @PatchMethod
    static Element getParentElement(Object domImpl, Node elem) {
        Node parent = elem.getParentNode();
        if (parent == null || parent.getNodeType() != 1) {
            return null;
        }
        return (Element)parent.cast();
    }

    @PatchMethod
    static int getScrollLeft(Object domImpl, Element elem) {
        return JavaScriptObjects.getInteger((JavaScriptObject)elem, SCROLL_LEFT);
    }

    @PatchMethod
    static String getStyleProperty(Object domImpl, Style style, String propertyName) {
        return GwtStyleUtils.getProperty(style, propertyName);
    }

    @PatchMethod
    static int getTabIndex(Object domImpl, Element elem) {
        return JavaScriptObjects.getInteger((JavaScriptObject)elem, TAB_INDEX);
    }

    @PatchMethod
    static String getTagName(Object domImpl, Element elem) {
        return JsoUtils.getTagName(elem);
    }

    @PatchMethod
    static boolean hasAttribute(Object domImpl, Element elem, String name) {
        PropertyContainer properties = JsoUtils.getDomProperties(elem);
        String propertyName = DOMImplPatcher.getDOMPropertyName(name);
        return properties.contains(propertyName);
    }

    @PatchMethod
    static String imgGetSrc(Object domImpl, Element img) {
        return img.getAttribute("src");
    }

    @PatchMethod
    static void imgSetSrc(Object domImpl, Element img, String src) {
        img.setAttribute("src", src);
    }

    @PatchMethod
    static boolean isOrHasChild(Object domImpl, Node parent, Node child) {
        while (child != null) {
            if (parent.equals((Object)child)) {
                return true;
            }
            child = child.getParentNode();
        }
        return false;
    }

    @PatchMethod
    static void scrollIntoView(Object domImpl, Element elem) {
    }

    @PatchMethod
    static void selectAdd(Object domImpl, SelectElement select, OptionElement option, OptionElement before) {
        if (before == null) {
            select.appendChild((Node)option);
        } else {
            select.insertBefore((Node)option, (Node)before);
        }
        DOMImplPatcher.refreshSelect(select);
    }

    @PatchMethod
    static void selectClear(Object domImpl, SelectElement select) {
        DOMImplPatcher.clearChildNodes((Element)select);
        select.setSelectedIndex(-1);
    }

    @PatchMethod
    static int selectGetLength(Object domImpl, SelectElement select) {
        return DOMImplPatcher.selectGetOptions(domImpl, select).getLength();
    }

    @PatchMethod
    static NodeList<OptionElement> selectGetOptions(Object domImpl, SelectElement select) {
        ArrayList<OptionElement> innerList = new ArrayList<OptionElement>();
        for (int i = 0; i < select.getChildNodes().getLength(); ++i) {
            Element e = (Element)select.getChildNodes().getItem(i).cast();
            if (!"option".equals(e.getTagName())) continue;
            OptionElement option = (OptionElement)e.cast();
            innerList.add(option);
        }
        return JsoUtils.newNodeList(innerList);
    }

    @PatchMethod
    static void selectRemoveOption(Object domImpl, SelectElement select, int index) {
        List<Node> list = JsoUtils.getChildNodeInnerList((Node)select);
        list.remove(index);
        DOMImplPatcher.refreshSelect(select);
    }

    @PatchMethod
    static void setInnerText(Object domImpl, Element elem, String text) {
        DOMImplPatcher.clearChildNodes(elem);
        elem.appendChild((Node)JsoUtils.newText(text, elem.getOwnerDocument()));
    }

    @PatchMethod
    static void setScrollLeft(Object domImpl, Element elem, int left) {
        JavaScriptObjects.setProperty((JavaScriptObject)elem, SCROLL_LEFT, left);
    }

    @PatchMethod
    static String toString(Object domImpl, Element elem) {
        return elem.toString();
    }

    private static void appendInnerTextRecursive(Element elem, StringBuilder sb) {
        NodeList list = elem.getChildNodes();
        block4: for (int i = 0; i < elem.getChildNodes().getLength(); ++i) {
            Node node = list.getItem(i);
            switch (node.getNodeType()) {
                case 3: {
                    Text text = (Text)node.cast();
                    String data = text.getData();
                    data = "&nbsp;".equals(data) ? " " : data;
                    sb.append(data);
                    continue block4;
                }
                case 1: {
                    Element childNode = (Element)node.cast();
                    DOMImplPatcher.appendInnerTextRecursive(childNode, sb);
                }
            }
        }
    }

    private static void clearChildNodes(Element elem) {
        List<Node> innerList = JsoUtils.getChildNodeInnerList((Node)elem);
        innerList.clear();
    }

    private static InputElement createInputElement(Document doc, String type, String name) {
        InputElement e = (InputElement)doc.createElement("input").cast();
        e.setAttribute("type", type);
        if (name != null) {
            e.setAttribute("name", name);
        }
        return e;
    }

    private static void refreshSelect(SelectElement select) {
        SelectElementPatcher.refreshSelect(select);
    }
}

