/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.rewrite;

import com.google.gwt.dev.asm.ClassAdapter;
import com.google.gwt.dev.asm.ClassVisitor;
import com.google.gwt.dev.asm.MethodAdapter;
import com.google.gwt.dev.asm.MethodVisitor;
import com.google.gwt.dev.asm.commons.Remapper;
import com.google.gwt.dev.shell.rewrite.HostedModeClassRewriter;
import com.googlecode.gwt.test.internal.rewrite.OverlayTypesRewriter;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RewriteRefsToJsoClasses
extends ClassAdapter {
    protected final Set<String> jsoDescriptors;
    private final HostedModeClassRewriter.InstanceMethodOracle mapper;

    public RewriteRefsToJsoClasses(ClassVisitor cv, Set<String> jsoDescriptors, HostedModeClassRewriter.InstanceMethodOracle mapper) {
        super(cv);
        this.jsoDescriptors = jsoDescriptors;
        this.mapper = mapper;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        return new MyMethodAdapter(mv);
    }

    private class MyMethodAdapter
    extends MethodAdapter {
        private final Remapper remapper;

        public MyMethodAdapter(MethodVisitor mv) {
            super(mv);
            this.remapper = new Remapper(){

                public String map(String typeName) {
                    if (RewriteRefsToJsoClasses.this.jsoDescriptors.contains(typeName)) {
                        return OverlayTypesRewriter.JAVASCRIPTOBJECT_IMPL_DESC;
                    }
                    return typeName;
                }
            };
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (RewriteRefsToJsoClasses.this.jsoDescriptors.contains(owner)) {
                owner = owner + "$";
            }
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitLdcInsn(Object cst) {
            cst = this.remapper.mapValue(cst);
            super.visitLdcInsn(cst);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (RewriteRefsToJsoClasses.this.jsoDescriptors.contains(owner)) {
                if (opcode == 182) {
                    owner = RewriteRefsToJsoClasses.this.mapper.findOriginalDeclaringClass(owner, name + desc);
                }
                if (!owner.equals("java/lang/Object")) {
                    if (opcode == 182 || opcode == 183) {
                        opcode = 184;
                        desc = OverlayTypesRewriter.addSyntheticThisParam(owner, desc);
                        name = name + "$";
                    }
                    owner = owner + "$";
                }
            }
            super.visitMethodInsn(opcode, owner, name, desc);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            desc = this.remapper.mapType(desc);
            super.visitMultiANewArrayInsn(desc, dims);
        }

        public void visitTypeInsn(int opcode, String type) {
            if (opcode == 189) {
                type = this.remapper.mapType(type);
            }
            super.visitTypeInsn(opcode, type);
        }
    }
}

