/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.uibinder;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.uibinder.client.UiFactory;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.UIObject;
import com.googlecode.gwt.test.exceptions.GwtTestUiBinderException;
import com.googlecode.gwt.test.internal.GwtParanamer;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UiBinderInstanciator {
    public static final Map<Class<?>, Class<?>> primitiveMap = new HashMap();

    UiBinderInstanciator() {
    }

    static <U> U getInstance(Class<U> clazz, Map<String, Object> attributes, Object owner) {
        String uiFieldValue = (String)attributes.get("ui:field");
        Object instance = UiBinderInstanciator.getProvidedUiField(clazz, owner, uiFieldValue);
        if (instance == null) {
            instance = UiBinderInstanciator.getObjectFromUiFactory(clazz, owner);
        }
        if (instance == null) {
            instance = UiBinderInstanciator.getObjectFromUiConstructor(clazz, attributes);
        }
        if (instance == null && !UIObject.class.isAssignableFrom(clazz) && !IsWidget.class.isAssignableFrom(clazz)) {
            instance = GWT.create(clazz);
        }
        return instance;
    }

    private static boolean allArgsAreDeclaredInUiFile(String[] argNames, Map<String, Object> attributes) {
        for (String argName : argNames) {
            if (attributes.containsKey(argName)) continue;
            return false;
        }
        return true;
    }

    private static Object convertArgs(Class<?> paramType, Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (paramType == String.class) {
            return object;
        }
        if (paramType.isPrimitive()) {
            paramType = primitiveMap.get(paramType);
        }
        Method valueOfMethod = null;
        try {
            valueOfMethod = paramType.getDeclaredMethod("valueOf", String.class);
            if (valueOfMethod.getReturnType() != paramType) {
                return object;
            }
        }
        catch (Exception e) {
            return object;
        }
        return valueOfMethod.invoke(null, object);
    }

    private static List<Object> extractArgs(String[] argNames, Map<String, Object> attributes) {
        ArrayList<Object> args = new ArrayList<Object>();
        for (String argName : argNames) {
            Object arg = attributes.get(argName);
            if (arg == null) {
                return null;
            }
            args.add(arg);
        }
        return args;
    }

    private static <U> U getObjectFromUiConstructor(Class<U> clazz, Map<String, Object> attributes) {
        for (Constructor<?> cons : clazz.getDeclaredConstructors()) {
            if (cons.getAnnotation(UiConstructor.class) == null) continue;
            Constructor<?> uiConstructor = cons;
            String[] argNames = GwtParanamer.get().lookupParameterNames(uiConstructor);
            if (!UiBinderInstanciator.allArgsAreDeclaredInUiFile(argNames, attributes)) continue;
            List<Object> constructorArgs = UiBinderInstanciator.extractArgs(argNames, attributes);
            if (constructorArgs != null) {
                Class<?>[] paramTypes = uiConstructor.getParameterTypes();
                for (int i = 0; i < argNames.length; ++i) {
                    String argName = argNames[i];
                    try {
                        Object convertedArg = UiBinderInstanciator.convertArgs(paramTypes[i], constructorArgs.get(i));
                        constructorArgs.set(i, convertedArg);
                        attributes.remove(argName);
                        continue;
                    }
                    catch (Exception e) {
                        throw new GwtTestUiBinderException("Error while converting argument " + argNames[i] + " to " + paramTypes[i], e);
                    }
                }
            }
            return (U)UiBinderInstanciator.instanciate(uiConstructor, constructorArgs);
        }
        return null;
    }

    private static <U> U getObjectFromUiFactory(Class<U> clazz, Object owner) {
        Map<Method, UiFactory> map = GwtReflectionUtils.getAnnotatedMethod(owner.getClass(), UiFactory.class);
        ArrayList<Method> compatibleFactories = new ArrayList<Method>();
        for (Method factoryMethod : map.keySet()) {
            if (!clazz.isAssignableFrom(factoryMethod.getReturnType())) continue;
            compatibleFactories.add(factoryMethod);
        }
        switch (compatibleFactories.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (U)GwtReflectionUtils.callPrivateMethod(owner, (Method)compatibleFactories.get(0), new Object[0]);
            }
        }
        throw new GwtTestUiBinderException("Duplicate factory in class '" + owner.getClass().getName() + " for type '" + clazz.getName() + "'");
    }

    private static <U> U getProvidedUiField(Class<U> clazz, Object owner, String uiFieldValue) {
        Map<Field, UiField> map = GwtReflectionUtils.getAnnotatedField(owner.getClass(), UiField.class);
        for (Map.Entry<Field, UiField> entry : map.entrySet()) {
            if (!entry.getValue().provided() || !entry.getKey().getName().equals(uiFieldValue) && (uiFieldValue != null || entry.getKey().getType() != clazz)) continue;
            Object providedObject = GwtReflectionUtils.getPrivateFieldValue(owner, entry.getKey());
            if (providedObject == null) {
                throw new GwtTestUiBinderException("The UiField(provided=true) '" + entry.getKey().getDeclaringClass().getSimpleName() + "." + entry.getKey().getName() + "' has not been initialized before calling 'UiBinder.createAndBind(..)' method");
            }
            return (U)providedObject;
        }
        return null;
    }

    private static <U> U instanciate(Constructor<U> cons, List<Object> args) {
        try {
            return GwtReflectionUtils.instantiateClass(cons, args.toArray());
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Error while calling @UiConstructor 'new ").append(cons.getDeclaringClass().getSimpleName()).append("(");
            for (Object arg : args) {
                sb.append("\"" + arg.toString() + "\"");
                sb.append(", ");
            }
            if (args.size() > 0) {
                sb.delete(sb.length() - 2, sb.length() - 1);
            }
            sb.append(");'");
            throw new GwtTestUiBinderException(sb.toString(), e);
        }
    }

    static {
        primitiveMap.put(Boolean.TYPE, Boolean.class);
        primitiveMap.put(Byte.TYPE, Byte.class);
        primitiveMap.put(Short.TYPE, Short.class);
        primitiveMap.put(Character.TYPE, Character.class);
        primitiveMap.put(Integer.TYPE, Integer.class);
        primitiveMap.put(Long.TYPE, Long.class);
        primitiveMap.put(Float.TYPE, Float.class);
        primitiveMap.put(Double.TYPE, Double.class);
    }
}

