/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.utils.events;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.shared.UmbrellaException;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.AbstractHasData;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IndexedPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.ValueBoxBase;
import com.google.gwt.user.client.ui.Widget;
import com.googlecode.gwt.test.finder.GwtFinder;
import com.googlecode.gwt.test.internal.BrowserSimulatorImpl;
import com.googlecode.gwt.test.internal.GwtConfig;
import com.googlecode.gwt.test.internal.utils.RadioButtonManager;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import com.googlecode.gwt.test.utils.JavaScriptObjects;
import com.googlecode.gwt.test.utils.WidgetUtils;
import com.googlecode.gwt.test.utils.events.EventBuilder;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Browser {
    public static <T extends IsWidget & HasText> void addText(T widget, String value) throws IllegalArgumentException {
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Cannot fill a null or empty text. If you intent to remove some text, use '" + Browser.class.getSimpleName() + ".emptyText(..)' instead");
        }
        for (int i = 0; i < value.length(); ++i) {
            Browser.pressKey(widget, value.charAt(i));
        }
    }

    public static void blur(IsWidget target) {
        Browser.dispatchEvent(target, EventBuilder.create(4096).build());
    }

    public static void blur(String ... identifier) throws ClassCastException {
        Browser.blur(GwtFinder.object(identifier).ofType(IsWidget.class));
    }

    public static void change(IsWidget target) {
        Browser.dispatchEvent(target, EventBuilder.create(1024).build());
    }

    public static void change(String ... identifier) throws ClassCastException {
        Browser.change(GwtFinder.object(identifier).ofType(IsWidget.class));
    }

    public static <T> void click(AbstractHasData<T> hasData, T item) {
        BrowserSimulatorImpl.get().fireLoopEnd();
        if (hasData.getSelectionModel() == null) {
            return;
        }
        T itemKey = hasData.getKeyProvider() != null ? hasData.getKeyProvider().getKey(item) : item;
        for (Object visibleContent : hasData.getVisibleItems()) {
            Object visibleKey = hasData.getKeyProvider() != null ? hasData.getKeyProvider().getKey(visibleContent) : visibleContent;
            if (!visibleKey.equals(itemKey)) continue;
            hasData.getSelectionModel().setSelected(item, !hasData.getSelectionModel().isSelected(item));
            BrowserSimulatorImpl.get().fireLoopEnd();
            return;
        }
        GwtConfig.get().getModuleRunner().getBrowserErrorHandler().onError("the item to click is now visible in the targeted " + hasData.getClass().getSimpleName() + " instance");
    }

    public static void click(Grid grid, int row, int column) {
        Widget target = grid.getWidget(row, column);
        Browser.clickInternal((IsWidget)grid, (UIObject)target);
    }

    public static void click(IsWidget target) {
        Browser.clickInternal(target, (UIObject)target.asWidget());
    }

    public static void click(MenuBar parent, int clickedItemIndex) {
        Browser.click(parent, WidgetUtils.getMenuItems(parent).get(clickedItemIndex));
    }

    public static void click(MenuBar menuBar, MenuItem clickedItem) {
        Browser.clickInternal((IsWidget)menuBar, (UIObject)clickedItem);
    }

    public static void click(String ... identifier) throws ClassCastException {
        Browser.click(GwtFinder.object(identifier).ofType(IsWidget.class));
    }

    public static void click(SuggestBox suggestBox, int clickedItemIndex) {
        Browser.click(suggestBox, WidgetUtils.getMenuItems(suggestBox).get(clickedItemIndex));
    }

    public static void click(SuggestBox suggestBox, MenuItem clickedItem) {
        Event onClick = EventBuilder.create(1).setTarget((UIObject)clickedItem).build();
        if (Browser.canApplyEvent((IsWidget)suggestBox, onClick)) {
            clickedItem.getCommand().execute();
        }
    }

    public static <T extends IndexedPanel & IsWidget> void click(T panel, int index) {
        Widget target = panel.getWidget(index);
        Browser.clickInternal(panel, (UIObject)target);
    }

    public static void clickFirstPage(SimplePager simplePager) {
        Image firstPage = (Image)GwtReflectionUtils.getPrivateFieldValue((Object)simplePager, "firstPage");
        Browser.click((IsWidget)firstPage);
    }

    public static void clickFirstPage(String ... identifier) throws ClassCastException {
        Browser.clickFirstPage(GwtFinder.object(identifier).ofType(SimplePager.class));
    }

    public static void clickHeader(AbstractCellTable<?> table, int index) {
        BrowserSimulatorImpl.get().fireLoopEnd();
        table.getColumnSortList().push(table.getColumn(index));
        ColumnSortEvent.fire(table, (ColumnSortList)table.getColumnSortList());
        BrowserSimulatorImpl.get().fireLoopEnd();
    }

    public static void clickLastPage(SimplePager simplePager) {
        Image lastPage = (Image)GwtReflectionUtils.getPrivateFieldValue((Object)simplePager, "lastPage");
        Browser.click((IsWidget)lastPage);
    }

    public static void clickLastPage(String ... identifier) throws ClassCastException {
        Browser.clickLastPage(GwtFinder.object(identifier).ofType(SimplePager.class));
    }

    public static void clickNextPage(SimplePager simplePager) {
        Image nextPage = (Image)GwtReflectionUtils.getPrivateFieldValue((Object)simplePager, "nextPage");
        Browser.click((IsWidget)nextPage);
    }

    public static void clickNextPage(String ... identifier) throws ClassCastException {
        Browser.clickNextPage(GwtFinder.object(identifier).ofType(SimplePager.class));
    }

    public static void clickPreviousPage(SimplePager simplePager) {
        Image prevPage = (Image)GwtReflectionUtils.getPrivateFieldValue((Object)simplePager, "prevPage");
        Browser.click((IsWidget)prevPage);
    }

    public static void clickPreviousPage(String ... identifier) throws ClassCastException {
        Browser.clickPreviousPage(GwtFinder.object(identifier).ofType(SimplePager.class));
    }

    public static void dblClick(IsWidget target) {
        Browser.dispatchEvent(target, EventBuilder.create(2).build());
    }

    public static void dblClick(String ... identifier) throws ClassCastException {
        Browser.dblClick(GwtFinder.object(identifier).ofType(IsWidget.class));
    }

    public static void dispatchEvent(IsWidget target, Event ... events) {
        Browser.dispatchEventsInternal(target, true, events);
    }

    public static void emptyText(HasText hasTextWidget) {
        boolean changed = false;
        int baseLength = hasTextWidget.getText().length();
        for (int i = 0; i < baseLength; ++i) {
            Event keyDownEvent = EventBuilder.create(128).setKeyCode(8).build();
            Browser.dispatchEvent((IsWidget)hasTextWidget, keyDownEvent);
            boolean keyDownEventPreventDefault = JavaScriptObjects.getBoolean((JavaScriptObject)keyDownEvent, "EVENT_preventDefault");
            if (keyDownEventPreventDefault) continue;
            hasTextWidget.setText(hasTextWidget.getText().substring(0, hasTextWidget.getText().length() - 1));
            changed = true;
        }
        Event keyUpEvent = EventBuilder.create(512).setKeyCode(8).build();
        Browser.dispatchEvent((IsWidget)hasTextWidget, keyUpEvent);
        Browser.dispatchEvent((IsWidget)hasTextWidget, EventBuilder.create(4096).build());
        if (changed) {
            Browser.dispatchEvent((IsWidget)hasTextWidget, EventBuilder.create(1024).build());
        }
    }

    public static void emptyText(HasText hasTextWidget, boolean longBackPress) {
        if (longBackPress) {
            Browser.emptyText(hasTextWidget);
        } else {
            Browser.removeText(hasTextWidget, hasTextWidget.getText().length());
        }
    }

    @Deprecated
    public static void fillText(HasText hasTextWidget, boolean check, boolean blur, String value) {
        Browser.fillText(value, check, blur, hasTextWidget);
    }

    @Deprecated
    public static void fillText(HasText hasTextWidget, boolean check, String value) throws IllegalArgumentException {
    }

    @Deprecated
    public static void fillText(HasText hasTextWidget, String value) throws IllegalArgumentException {
        Browser.fillText(value, hasTextWidget);
    }

    public static void fillText(String value, boolean check, boolean blur, HasText hasTextWidget) throws IllegalArgumentException {
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Cannot fill a null or empty text. If you intent to remove some text, use '" + Browser.class.getSimpleName() + ".emptyText(..)' instead");
        }
        if (!Widget.class.isInstance(hasTextWidget)) {
            return;
        }
        boolean changed = false;
        for (int i = 0; i < value.length(); ++i) {
            char keyCode = value.charAt(i);
            Event keyDownEvent = EventBuilder.create(128).setKeyCode(keyCode).build();
            Event keyPressEvent = EventBuilder.create(256).setKeyCode(keyCode).build();
            Browser.dispatchEventsInternal((IsWidget)hasTextWidget, check, keyDownEvent, keyPressEvent);
            boolean keyDownEventPreventDefault = JavaScriptObjects.getBoolean((JavaScriptObject)keyDownEvent, "EVENT_preventDefault");
            boolean keyPressEventPreventDefault = JavaScriptObjects.getBoolean((JavaScriptObject)keyPressEvent, "EVENT_preventDefault");
            if (!keyDownEventPreventDefault && !keyPressEventPreventDefault) {
                hasTextWidget.setText(value.substring(0, i + 1));
                changed = true;
                if (hasTextWidget instanceof ValueBoxBase) {
                    JavaScriptObjects.setProperty((JavaScriptObject)((Widget)hasTextWidget).getElement(), "SELECTION_START", i + 1);
                    JavaScriptObjects.setProperty((JavaScriptObject)((Widget)hasTextWidget).getElement(), "SELECTION_END", i + 1);
                }
            }
            Event keyUpEvent = EventBuilder.create(512).setKeyCode(keyCode).build();
            Browser.dispatchEventsInternal((IsWidget)hasTextWidget, check, keyUpEvent);
        }
        if (blur) {
            Browser.dispatchEventsInternal((IsWidget)hasTextWidget, false, EventBuilder.create(4096).build());
            if (changed) {
                Browser.dispatchEventsInternal((IsWidget)hasTextWidget, false, EventBuilder.create(1024).build());
            }
        }
    }

    public static void fillText(String value, boolean check, boolean blur, String ... identifier) throws ClassCastException, IllegalArgumentException {
        Browser.fillText(value, check, blur, GwtFinder.object(identifier).ofType(HasText.class));
    }

    public static void fillText(String value, boolean check, HasText hasTextWidget) throws IllegalArgumentException {
        Browser.fillText(value, check, true, hasTextWidget);
    }

    public static void fillText(String value, boolean check, String ... identifier) throws ClassCastException, IllegalArgumentException {
        Browser.fillText(value, check, true, identifier);
    }

    public static void fillText(String value, HasText hasTextWidget) throws IllegalArgumentException {
        Browser.fillText(value, true, true, hasTextWidget);
    }

    public static void fillText(String value, String ... identifier) throws ClassCastException, IllegalArgumentException {
        Browser.fillText(value, true, true, GwtFinder.object(identifier).ofType(HasText.class));
    }

    public static void focus(IsWidget target) {
        Browser.dispatchEvent(target, EventBuilder.create(2048).build());
    }

    public static void focus(String ... identifier) throws ClassCastException {
        Browser.focus(GwtFinder.object(identifier).ofType(IsWidget.class));
    }

    public static void keyDown(int keyCode, IsWidget target) {
        Browser.dispatchEvent(target, EventBuilder.create(128).setKeyCode(keyCode).build());
    }

    public static void keyDown(int keyCode, String ... identifier) throws ClassCastException {
        Browser.keyDown(keyCode, GwtFinder.object(identifier).ofType(IsWidget.class));
    }

    @Deprecated
    public static void keyDown(IsWidget target, int keyCode) {
        Browser.keyDown(keyCode, target);
    }

    public static void keyPress(int keyCode, IsWidget target) {
        Browser.dispatchEvent(target, EventBuilder.create(256).setKeyCode(keyCode).build());
    }

    public static void keyPress(int keyCode, String ... identifier) throws ClassCastException {
        Browser.keyPress(keyCode, GwtFinder.object(identifier).ofType(IsWidget.class));
    }

    @Deprecated
    public static void keyPress(IsWidget target, int keyCode) {
        Browser.keyPress(keyCode, target);
    }

    public static void keyUp(int keyCode, IsWidget target) {
        Browser.dispatchEvent(target, EventBuilder.create(512).setKeyCode(keyCode).build());
    }

    public static void keyUp(int keyCode, String ... identifier) throws ClassCastException {
        Browser.keyUp(keyCode, GwtFinder.object(identifier).ofType(IsWidget.class));
    }

    @Deprecated
    public static void keyUp(IsWidget target, int keyCode) {
        Browser.keyUp(keyCode, target);
    }

    public static void mouseDown(IsWidget target) {
        Browser.dispatchEvent(target, EventBuilder.create(4).build());
    }

    public static void mouseDown(String ... identifier) throws ClassCastException {
        Browser.mouseDown(GwtFinder.object(identifier).ofType(IsWidget.class));
    }

    public static void mouseMove(IsWidget target) {
        Browser.dispatchEvent(target, EventBuilder.create(64).build());
    }

    public static void mouseMove(String ... identifier) throws ClassCastException {
        Browser.mouseMove(GwtFinder.object(identifier).ofType(IsWidget.class));
    }

    public static void mouseOut(IsWidget target) {
        Browser.dispatchEvent(target, EventBuilder.create(32).build());
    }

    public static void mouseOut(String ... identifier) throws ClassCastException {
        Browser.mouseOut(GwtFinder.object(identifier).ofType(IsWidget.class));
    }

    public static void mouseOver(IsWidget target) {
        Browser.dispatchEvent(target, EventBuilder.create(16).build());
    }

    public static void mouseOver(String ... identifier) throws ClassCastException {
        Browser.mouseOver(GwtFinder.object(identifier).ofType(IsWidget.class));
    }

    public static void mouseUp(IsWidget target) {
        Browser.dispatchEvent(target, EventBuilder.create(8).build());
    }

    public static void mouseUp(String ... identifier) throws ClassCastException {
        Browser.mouseUp(GwtFinder.object(identifier).ofType(IsWidget.class));
    }

    public static void mouseWheel(IsWidget target) {
        Browser.dispatchEvent(target, EventBuilder.create(131072).build());
    }

    public static void mouseWheel(String ... identifier) throws ClassCastException {
        Browser.mouseWheel(GwtFinder.object(identifier).ofType(IsWidget.class));
    }

    public static <T extends IsWidget & HasText> void pressKey(int keyCode, T widget) {
        if (widget == null) {
            return;
        }
        Event keyDownEvent = EventBuilder.create(128).setKeyCode(keyCode).build();
        Event keyPressEvent = EventBuilder.create(256).setKeyCode(keyCode).build();
        Browser.dispatchEventsInternal(widget, true, keyDownEvent, keyPressEvent);
        boolean keyDownEventPreventDefault = JavaScriptObjects.getBoolean((JavaScriptObject)keyDownEvent, "EVENT_preventDefault");
        boolean keyPressEventPreventDefault = JavaScriptObjects.getBoolean((JavaScriptObject)keyPressEvent, "EVENT_preventDefault");
        if (!keyDownEventPreventDefault && !keyPressEventPreventDefault) {
            StringBuilder sb = new StringBuilder(((HasText)widget).getText());
            int selectionStart = JavaScriptObjects.getInteger((JavaScriptObject)widget.asWidget().getElement(), "SELECTION_START");
            int selectionEnd = JavaScriptObjects.getInteger((JavaScriptObject)widget.asWidget().getElement(), "SELECTION_END");
            switch (keyCode) {
                case 13: 
                case 16: 
                case 17: 
                case 18: 
                case 27: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 46: {
                    break;
                }
                case 9: {
                    Browser.blur(widget);
                    break;
                }
                case 8: {
                    if (selectionStart == selectionEnd) {
                        sb.deleteCharAt(selectionStart);
                    } else {
                        sb.replace(selectionStart, selectionEnd, "");
                    }
                    ((HasText)widget).setText(sb.toString());
                    break;
                }
                default: {
                    sb.replace(selectionStart, selectionEnd, "");
                    sb.insert(selectionStart, (char)keyCode);
                    selectionStart = selectionEnd = selectionStart + 1;
                    ((HasText)widget).setText(sb.toString());
                    JavaScriptObjects.setProperty((JavaScriptObject)widget.asWidget().getElement(), "SELECTION_START", selectionStart);
                    JavaScriptObjects.setProperty((JavaScriptObject)widget.asWidget().getElement(), "SELECTION_END", selectionEnd);
                }
            }
            Event keyUpEvent = EventBuilder.create(512).setKeyCode(keyCode).build();
            Browser.dispatchEventsInternal(widget, true, keyUpEvent);
        }
    }

    @Deprecated
    public static <T extends IsWidget & HasText> void pressKey(T widget, int keyCode) {
        Browser.pressKey(keyCode, widget);
    }

    public static void removeText(HasText hasTextWidget, int backspacePressNumber) {
        boolean changed = false;
        for (int i = 0; i < backspacePressNumber; ++i) {
            Event keyDownEvent = EventBuilder.create(128).setKeyCode(8).build();
            Event keyUpEvent = EventBuilder.create(512).setKeyCode(8).build();
            Browser.dispatchEvent((IsWidget)hasTextWidget, keyDownEvent, keyUpEvent);
            boolean keyDownEventPreventDefault = JavaScriptObjects.getBoolean((JavaScriptObject)keyDownEvent, "EVENT_preventDefault");
            if (keyDownEventPreventDefault) continue;
            hasTextWidget.setText(hasTextWidget.getText().substring(0, hasTextWidget.getText().length() - 1));
            changed = true;
        }
        Browser.dispatchEvent((IsWidget)hasTextWidget, EventBuilder.create(4096).build());
        if (changed) {
            Browser.dispatchEvent((IsWidget)hasTextWidget, EventBuilder.create(1024).build());
        }
    }

    public static boolean submit(FormPanel form, String resultsHtml) {
        Element synthesizedFrame = (Element)GwtReflectionUtils.getPrivateFieldValue((Object)form, "synthesizedFrame");
        if (synthesizedFrame == null) {
            GwtConfig.get().getModuleRunner().getBrowserErrorHandler().onError("Cannot submit form which is not attached to the DOM '");
            return false;
        }
        synthesizedFrame.setInnerHTML(resultsHtml);
        form.submit();
        return true;
    }

    private static boolean canApplyEvent(IsWidget target, Event event) {
        Widget widget = target.asWidget();
        if (!widget.isAttached() && !GwtConfig.get().getModuleRunner().canDispatchEventsOnDetachedWidgets()) {
            GwtConfig.get().getModuleRunner().getBrowserErrorHandler().onError("Cannot dispatch '" + event.getType() + "' event : the targeted widget is not attached to the DOM");
            return false;
        }
        Element targetElement = (Element)event.getEventTarget().cast();
        if (!WidgetUtils.isWidgetVisible((UIObject)widget) && Browser.isVisible(widget, targetElement)) {
            GwtConfig.get().getModuleRunner().getBrowserErrorHandler().onError("Cannot dispatch '" + event.getType() + "' event : the targeted element or one of its parents is not visible");
            return false;
        }
        if (Browser.isDisabled(targetElement)) {
            GwtConfig.get().getModuleRunner().getBrowserErrorHandler().onError("Cannot dispatch '" + event.getType() + "' event : the targeted element has to be enabled : " + targetElement.toString());
            return false;
        }
        return true;
    }

    private static void clickInternal(IsWidget parent, UIObject target) {
        Event onMouseOver = EventBuilder.create(16).setTarget(target).build();
        Event onMouseDown = EventBuilder.create(4).setTarget(target).setButton(1).build();
        Event onMouseUp = EventBuilder.create(8).setTarget(target).setButton(1).build();
        Event onClick = EventBuilder.create(1).setTarget(target).build();
        Browser.dispatchEvent(parent, onMouseOver, onMouseDown, onMouseUp, onClick);
    }

    private static void clickOnCheckBox(CheckBox checkBox) {
        boolean newValue = RadioButton.class.isInstance(checkBox) ? true : checkBox.getValue() == false;
        WidgetUtils.setCheckBoxValueSilent(checkBox, newValue);
        if (RadioButton.class.isInstance(checkBox)) {
            RadioButtonManager.onRadioGroupChanged((RadioButton)checkBox, newValue, true);
        }
    }

    private static void dispatchEventInternal(IsWidget target, Event event) {
        try {
            Object relatedTargetElement;
            if (CheckBox.class.isInstance(target) && event.getTypeInt() == 1) {
                Browser.clickOnCheckBox((CheckBox)target);
            }
            if ((relatedTargetElement = (Element)JavaScriptObjects.getObject((JavaScriptObject)event, "EVENT_relatedTarget")) == null) {
                switch (event.getTypeInt()) {
                    case 16: 
                    case 32: {
                        Widget parent = target.asWidget().getParent();
                        relatedTargetElement = parent != null ? parent.getElement() : Document.get().getDocumentElement();
                        JavaScriptObjects.setProperty((JavaScriptObject)event, "EVENT_relatedTarget", relatedTargetElement);
                    }
                }
            }
            HashSet<Widget> applied = new HashSet<Widget>();
            Browser.dispatchEventWithBubble(target, event, applied);
        }
        catch (UmbrellaException e) {
            if (AssertionError.class.isInstance(e.getCause())) {
                throw (AssertionError)((Object)e.getCause());
            }
            if (RuntimeException.class.isInstance(e.getCause())) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    private static void dispatchEventsInternal(IsWidget target, boolean check, Event ... events) {
        boolean dipsatch;
        if (events.length == 0) {
            return;
        }
        Browser.prepareEvents(target, events);
        boolean bl = dipsatch = check ? Browser.canApplyEvent(target, events[0]) : true;
        if (dipsatch) {
            for (Event event : events) {
                Browser.dispatchEventInternal(target, event);
            }
        }
    }

    private static void dispatchEventWithBubble(IsWidget target, Event event, Set<Widget> applied) {
        if (target == null) {
            return;
        }
        Widget widget = target.asWidget();
        if (widget == null || Browser.isEventStopped(event) || applied.contains(widget)) {
            return;
        }
        if (widget.getParent() instanceof Composite) {
            widget = widget.getParent();
        }
        widget.onBrowserEvent(event);
        applied.add(widget);
        Browser.dispatchEventWithBubble((IsWidget)Browser.getParent(widget.getElement().getParentElement()), event, applied);
    }

    private static Widget getParent(Element parentElement) {
        if (parentElement == null) {
            return null;
        }
        EventListener o = DOM.getEventListener((com.google.gwt.user.client.Element)((com.google.gwt.user.client.Element)parentElement.cast()));
        if (!Widget.class.isInstance(o)) {
            return Browser.getParent(parentElement.getParentElement());
        }
        return (Widget)o;
    }

    private static boolean isDisabled(Element element) {
        return element.getPropertyBoolean("disabled") || element.getClassName().contains("gwt-CheckBox-disabled");
    }

    private static boolean isEventStopped(Event event) {
        return JavaScriptObjects.getBoolean((JavaScriptObject)event, "EVENT_isStopped");
    }

    private static boolean isVisible(Widget visibleRoot, Element element) {
        if (element == null) {
            return false;
        }
        if (element == visibleRoot.getElement()) {
            return true;
        }
        return UIObject.isVisible((Element)element) ? Browser.isVisible(visibleRoot, element.getParentElement()) : false;
    }

    private static void prepareEvents(IsWidget target, Event ... events) {
        for (Event event : events) {
            Element effectiveTarget = (Element)JavaScriptObjects.getObject((JavaScriptObject)event, "EVENT_target");
            if (effectiveTarget != null) continue;
            effectiveTarget = target.asWidget().getElement();
            JavaScriptObjects.setProperty((JavaScriptObject)event, "EVENT_target", effectiveTarget);
        }
    }

    private Browser() {
    }

    public static interface BrowserErrorHandler {
        public void onError(String var1);
    }
}

