/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.web;

import com.googlecode.gwt.test.internal.utils.LinkedCaseInsensitiveMap;
import com.googlecode.gwt.test.web.DelegatingServletInputStream;
import com.googlecode.gwt.test.web.HeaderValueHolder;
import com.googlecode.gwt.test.web.MockHttpSession;
import com.googlecode.gwt.test.web.MockRequestDispatcher;
import com.googlecode.gwt.test.web.MockServletContext;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.MapAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.StringAssert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockHttpServletRequest
implements HttpServletRequest {
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String DEFAULT_REMOTE_ADDR = "127.0.0.1";
    public static final String DEFAULT_REMOTE_HOST = "localhost";
    public static final String DEFAULT_SERVER_ADDR = "127.0.0.1";
    public static final String DEFAULT_SERVER_NAME = "localhost";
    public static final int DEFAULT_SERVER_PORT = 80;
    private boolean active = true;
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private String authType;
    private String characterEncoding;
    private byte[] content;
    private String contentType;
    private String contextPath = "";
    private Cookie[] cookies;
    private final Map<String, HeaderValueHolder> headers = new LinkedCaseInsensitiveMap<HeaderValueHolder>();
    private String localAddr = "127.0.0.1";
    private final List<Locale> locales = new LinkedList<Locale>();
    private String localName = "localhost";
    private int localPort = 80;
    private String method;
    private final Map<String, String[]> parameters = new LinkedHashMap<String, String[]>(16);
    private String pathInfo;
    private String protocol = "http";
    private String queryString;
    private String remoteAddr = "127.0.0.1";
    private String remoteHost = "localhost";
    private int remotePort = 80;
    private String remoteUser;
    private String requestedSessionId;
    private boolean requestedSessionIdFromCookie = true;
    private boolean requestedSessionIdFromURL = false;
    private boolean requestedSessionIdValid = true;
    private String requestURI;
    private String scheme = "http";
    private boolean secure = false;
    private String serverName = "localhost";
    private int serverPort = 80;
    private final ServletContext servletContext;
    private String servletPath = "";
    private HttpSession session;
    private Principal userPrincipal;
    private final Set<String> userRoles = new HashSet<String>();

    public MockHttpServletRequest() {
        this(null, "", "");
    }

    public MockHttpServletRequest(ServletContext servletContext) {
        this(servletContext, "", "");
    }

    public MockHttpServletRequest(ServletContext servletContext, String method, String requestURI) {
        this.servletContext = servletContext != null ? servletContext : new MockServletContext();
        this.method = method;
        this.requestURI = requestURI;
        this.locales.add(Locale.ENGLISH);
    }

    public MockHttpServletRequest(String method, String requestURI) {
        this(null, method, requestURI);
    }

    public void addHeader(String name, Object value) {
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        ((ObjectAssert)Assertions.assertThat((Object)value).as("Header value must not be null")).isNotNull();
        if (header == null) {
            header = new HeaderValueHolder();
            this.headers.put(name, header);
        }
        if (value instanceof Collection) {
            header.addValues((Collection)value);
        } else if (value.getClass().isArray()) {
            header.addValueArray(value);
        } else {
            header.addValue(value);
        }
    }

    public void addParameter(String name, String value) {
        this.addParameter(name, new String[]{value});
    }

    public void addParameter(String name, String[] values) {
        ((StringAssert)Assertions.assertThat((String)name).as("Parameter name must not be null")).isNotNull();
        String[] oldArr = this.parameters.get(name);
        if (oldArr != null) {
            String[] newArr = new String[oldArr.length + values.length];
            System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
            System.arraycopy(values, 0, newArr, oldArr.length, values.length);
            this.parameters.put(name, newArr);
        } else {
            this.parameters.put(name, values);
        }
    }

    public void addParameters(Map<?, ?> params) {
        ((MapAssert)Assertions.assertThat(params).as("Parameter map must not be null")).isNotNull();
        for (Object key : params.keySet()) {
            ((ObjectAssert)Assertions.assertThat(key).as("Parameter map key must be of type [" + String.class.getName() + "]")).isInstanceOf(String.class);
            Object value = params.get(key);
            if (value instanceof String) {
                this.addParameter((String)key, (String)value);
                continue;
            }
            if (value instanceof String[]) {
                this.addParameter((String)key, (String[])value);
                continue;
            }
            throw new IllegalArgumentException("Parameter map value must be single value  or array of type [" + String.class.getName() + "]");
        }
    }

    public void addPreferredLocale(Locale locale) {
        ((ObjectAssert)Assertions.assertThat((Object)locale).as("Locale must not be null")).isNotNull();
        this.locales.add(0, locale);
    }

    public void addUserRole(String role) {
        this.userRoles.add(role);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public void close() {
        this.active = false;
    }

    public Object getAttribute(String name) {
        this.checkActive();
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        this.checkActive();
        return new Vector<String>(this.attributes.keySet()).elements();
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public int getContentLength() {
        return this.content != null ? this.content.length : -1;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public long getDateHeader(String name) {
        Object value;
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        Object object = value = header != null ? header.getValue() : null;
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value != null) {
            throw new IllegalArgumentException("Value for header '" + name + "' is neither a Date nor a Number: " + value);
        }
        return -1L;
    }

    public String getHeader(String name) {
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        return header != null ? header.getValue().toString() : null;
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public Enumeration<String> getHeaders(String name) {
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        return Collections.enumeration(header != null ? header.getStringValues() : new LinkedList());
    }

    public ServletInputStream getInputStream() {
        if (this.content != null) {
            return new DelegatingServletInputStream(new ByteArrayInputStream(this.content));
        }
        return null;
    }

    public int getIntHeader(String name) {
        Object value;
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        Object object = value = header != null ? header.getValue() : null;
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        if (value != null) {
            throw new NumberFormatException("Value for header '" + name + "' is not a Number: " + value);
        }
        return -1;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public Locale getLocale() {
        return this.locales.get(0);
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(this.locales);
    }

    public String getLocalName() {
        return this.localName;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public String getMethod() {
        return this.method;
    }

    public String getParameter(String name) {
        ((StringAssert)Assertions.assertThat((String)name).as("Parameter name must not be null")).isNotNull();
        String[] arr = this.parameters.get(name);
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        ((StringAssert)Assertions.assertThat((String)name).as("Parameter name must not be null")).isNotNull();
        return this.parameters.get(name);
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.pathInfo != null ? this.getRealPath(this.pathInfo) : null;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public BufferedReader getReader() throws UnsupportedEncodingException {
        if (this.content != null) {
            ByteArrayInputStream sourceStream = new ByteArrayInputStream(this.content);
            InputStreamReader sourceReader = this.characterEncoding != null ? new InputStreamReader((InputStream)sourceStream, this.characterEncoding) : new InputStreamReader(sourceStream);
            return new BufferedReader(sourceReader);
        }
        return null;
    }

    public String getRealPath(String path) {
        return this.servletContext.getRealPath(path);
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new MockRequestDispatcher(path);
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer(this.scheme);
        url.append("://").append(this.serverName).append(':').append(this.serverPort);
        url.append(this.getRequestURI());
        return url;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        this.checkActive();
        if (this.session instanceof MockHttpSession && ((MockHttpSession)this.session).isInvalid()) {
            this.session = null;
        }
        if (this.session == null && create) {
            this.session = new MockHttpSession(this.servletContext);
        }
        return this.session;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public void invalidate() {
        this.close();
        this.clearAttributes();
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.requestedSessionIdFromURL;
    }

    public boolean isRequestedSessionIdValid() {
        return this.requestedSessionIdValid;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isUserInRole(String role) {
        return this.userRoles.contains(role);
    }

    public void removeAllParameters() {
        this.parameters.clear();
    }

    public void removeAttribute(String name) {
        this.checkActive();
        ((StringAssert)Assertions.assertThat((String)name).as("Attribute name must not be null")).isNotNull();
        this.attributes.remove(name);
    }

    public void removeParameter(String name) {
        ((StringAssert)Assertions.assertThat((String)name).as("Parameter name must not be null")).isNotNull();
        this.parameters.remove(name);
    }

    public void setAttribute(String name, Object value) {
        this.checkActive();
        ((StringAssert)Assertions.assertThat((String)name).as("Attribute name must not be null")).isNotNull();
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setCookies(Cookie ... cookies) {
        this.cookies = cookies;
    }

    public void setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setParameter(String name, String value) {
        this.setParameter(name, new String[]{value});
    }

    public void setParameter(String name, String[] values) {
        ((StringAssert)Assertions.assertThat((String)name).as("Parameter name must not be null")).isNotNull();
        this.parameters.put(name, values);
    }

    public void setParameters(Map<?, ?> params) {
        ((MapAssert)Assertions.assertThat(params).as("Parameter map must not be null")).isNotNull();
        for (Object key : params.keySet()) {
            ((ObjectAssert)Assertions.assertThat(key).as("Parameter map key must be of type [" + String.class.getName() + "]")).isInstanceOf(String.class);
            Object value = params.get(key);
            if (value instanceof String) {
                this.setParameter((String)key, (String)value);
                continue;
            }
            if (value instanceof String[]) {
                this.setParameter((String)key, (String[])value);
                continue;
            }
            throw new IllegalArgumentException("Parameter map value must be single value  or array of type [" + String.class.getName() + "]");
        }
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public void setRequestedSessionId(String requestedSessionId) {
        this.requestedSessionId = requestedSessionId;
    }

    public void setRequestedSessionIdFromCookie(boolean requestedSessionIdFromCookie) {
        this.requestedSessionIdFromCookie = requestedSessionIdFromCookie;
    }

    public void setRequestedSessionIdFromURL(boolean requestedSessionIdFromURL) {
        this.requestedSessionIdFromURL = requestedSessionIdFromURL;
    }

    public void setRequestedSessionIdValid(boolean requestedSessionIdValid) {
        this.requestedSessionIdValid = requestedSessionIdValid;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public void setSession(HttpSession session) {
        this.session = session;
        if (session instanceof MockHttpSession) {
            MockHttpSession mockSession = (MockHttpSession)session;
            mockSession.access();
        }
    }

    public void setUserPrincipal(Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    protected void checkActive() throws IllegalStateException {
        if (!this.active) {
            throw new IllegalStateException("Request is not active anymore");
        }
    }
}

