/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.web;

import com.googlecode.gwt.test.web.MockServletContext;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.StringAssert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockHttpSession
implements HttpSession {
    public static final String SESSION_COOKIE_NAME = "JSESSION";
    private static int nextId = 1;
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private final long creationTime = System.currentTimeMillis();
    private final String id;
    private boolean invalid = false;
    private boolean isNew = true;
    private long lastAccessedTime = System.currentTimeMillis();
    private int maxInactiveInterval;
    private final ServletContext servletContext;

    public MockHttpSession() {
        this(null);
    }

    public MockHttpSession(ServletContext servletContext) {
        this(servletContext, null);
    }

    public MockHttpSession(ServletContext servletContext, String id) {
        this.servletContext = servletContext != null ? servletContext : new MockServletContext();
        this.id = id != null ? id : Integer.toString(nextId++);
    }

    public void access() {
        this.lastAccessedTime = System.currentTimeMillis();
        this.isNew = false;
    }

    public void clearAttributes() {
        Iterator<Map.Entry<String, Object>> it = this.attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            Object value = entry.getValue();
            it.remove();
            if (!(value instanceof HttpSessionBindingListener)) continue;
            ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name, value));
        }
    }

    public void deserializeState(Serializable state) {
        ((ObjectAssert)Assertions.assertThat((Object)state).as("Serialized state needs to be of type [java.util.Map]")).isInstanceOf(Map.class);
        this.attributes.putAll((Map)((Object)state));
    }

    public Object getAttribute(String name) {
        ((StringAssert)Assertions.assertThat((String)name).as("Attribute name must not be null")).isNotNull();
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return new Vector<String>(this.attributes.keySet()).elements();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public HttpSessionContext getSessionContext() {
        throw new UnsupportedOperationException("getSessionContext");
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public void invalidate() {
        this.invalid = true;
        this.clearAttributes();
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        ((StringAssert)Assertions.assertThat((String)name).as("Attribute name must not be null")).isNotNull();
        Object value = this.attributes.remove(name);
        if (value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name, value));
        }
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public Serializable serializeState() {
        HashMap<String, Serializable> state = new HashMap<String, Serializable>();
        Iterator<Map.Entry<String, Object>> it = this.attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            Object value = entry.getValue();
            it.remove();
            if (value instanceof Serializable) {
                state.put(name, (Serializable)value);
                continue;
            }
            if (!(value instanceof HttpSessionBindingListener)) continue;
            ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name, value));
        }
        return state;
    }

    public void setAttribute(String name, Object value) {
        ((StringAssert)Assertions.assertThat((String)name).as("Attribute name must not be null")).isNotNull();
        if (value != null) {
            this.attributes.put(name, value);
            if (value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)this, name, value));
            }
        } else {
            this.removeAttribute(name);
        }
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    public void setNew(boolean value) {
        this.isNew = value;
    }
}

