/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.web;

import com.googlecode.gwt.test.web.MockRequestDispatcher;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.activation.FileTypeMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.StringAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockServletContext
implements ServletContext {
    public static final String TEMP_DIR_CONTEXT_ATTRIBUTE = "javax.servlet.context.tempdir";
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private String contextPath = "";
    private final Map<String, ServletContext> contexts = new HashMap<String, ServletContext>();
    private final Map<String, String> initParameters = new LinkedHashMap<String, String>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int minorVersion = 5;
    private String serverInfo = "MockServerInfo";
    private String servletContextName = "MockServletContext";

    public void addInitParameter(String name, String value) {
        ((StringAssert)Assertions.assertThat((String)name).as("Parameter name must not be null")).isNotNull();
        this.initParameters.put(name, value);
    }

    public Object getAttribute(String name) {
        ((StringAssert)Assertions.assertThat((String)name).as("Attribute name must not be null")).isNotNull();
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return new Vector<String>(this.attributes.keySet()).elements();
    }

    public ServletContext getContext(String contextPath) {
        if (this.contextPath.equals(contextPath)) {
            return this;
        }
        return this.contexts.get(contextPath);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getInitParameter(String name) {
        ((StringAssert)Assertions.assertThat((String)name).as("Parameter name must not be null")).isNotNull();
        return this.initParameters.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParameters.keySet());
    }

    public int getMajorVersion() {
        return 2;
    }

    public String getMimeType(String filePath) {
        return MimeTypeResolver.getMimeType(filePath);
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public RequestDispatcher getNamedDispatcher(String path) {
        return null;
    }

    public String getRealPath(String path) {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("RequestDispatcher path at ServletContext level must start with '/'");
        }
        return new MockRequestDispatcher(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        return null;
    }

    public Set<String> getResourcePaths() {
        return Collections.emptySet();
    }

    public Set<?> getResourcePaths(String arg0) {
        return Collections.emptySet();
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public Servlet getServlet(String name) {
        return null;
    }

    public String getServletContextName() {
        return this.servletContextName;
    }

    public Enumeration<String> getServletNames() {
        return Collections.enumeration(new HashSet());
    }

    public Enumeration<Servlet> getServlets() {
        return Collections.enumeration(new HashSet());
    }

    public void log(Exception ex, String message) {
        this.logger.info(message, (Throwable)ex);
    }

    public void log(String message) {
        this.logger.info(message);
    }

    public void log(String message, Throwable ex) {
        this.logger.info(message, ex);
    }

    public void registerContext(String contextPath, ServletContext context) {
        this.contexts.put(contextPath, context);
    }

    public void removeAttribute(String name) {
        ((StringAssert)Assertions.assertThat((String)name).as("Attribute name must not be null")).isNotNull();
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        ((StringAssert)Assertions.assertThat((String)name).as("Attribute name must not be null")).isNotNull();
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath != null ? contextPath : "";
    }

    public void setMinorVersion(int minorVersion) {
        if (minorVersion < 3 || minorVersion > 5) {
            throw new IllegalArgumentException("Only Servlet minor versions between 3 and 5 are supported");
        }
        this.minorVersion = minorVersion;
    }

    public void setServerInfo(String serverInfo) {
        this.serverInfo = serverInfo;
    }

    public void setServletContextName(String servletContextName) {
        this.servletContextName = servletContextName;
    }

    private static class MimeTypeResolver {
        private MimeTypeResolver() {
        }

        public static String getMimeType(String filePath) {
            return FileTypeMap.getDefaultFileTypeMap().getContentType(filePath);
        }
    }
}

