/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.paranamer;

import com.thoughtworks.paranamer.ParameterNamesNotFoundException;
import com.thoughtworks.paranamer.Paranamer;
import japa.parser.JavaParser;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.PackageDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.ConstructorDeclaration;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.Parameter;
import japa.parser.ast.visitor.GenericVisitor;
import japa.parser.ast.visitor.GenericVisitorAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaFileParanamer
implements Paranamer {
    private final Map<AccessibleObject, String[]> cache;
    private final JavaFileFinder javaFileFinder;

    public JavaFileParanamer(JavaFileFinder javaFileFinder) {
        this.javaFileFinder = javaFileFinder;
        this.cache = new HashMap<AccessibleObject, String[]>();
    }

    public String[] lookupParameterNames(AccessibleObject methodOrConstructor) {
        return this.lookupParameterNames(methodOrConstructor, true);
    }

    public String[] lookupParameterNames(AccessibleObject methodOrConstructor, boolean throwExceptionIfMissing) {
        if (methodOrConstructor == null) {
            throw new NullPointerException("method or constructor to inspect cannot be null");
        }
        String[] result = this.cache.get(methodOrConstructor);
        if (result == null) {
            this.visitJavaFileToPopulateCache(methodOrConstructor);
            result = this.cache.get(methodOrConstructor);
        }
        if (result == null && throwExceptionIfMissing) {
            throw new ParameterNamesNotFoundException("Cannot retrieve parameter names for method " + methodOrConstructor.toString());
        }
        return result;
    }

    private void visitJavaFileToPopulateCache(AccessibleObject methodOrConstructor) {
        InputStream is = null;
        try {
            is = this.javaFileFinder.openJavaFile(methodOrConstructor);
            if (is != null) {
                CompilationUnit cu = JavaParser.parse((InputStream)is);
                MethodParametersVisitor visitor = new MethodParametersVisitor();
                cu.accept((GenericVisitor)visitor, this.cache);
            }
        }
        catch (Exception e) {
            throw new ParameterNamesNotFoundException("Error while trying to read parameter names from the Java file which contains the declaration of " + methodOrConstructor.toString(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodParametersVisitor
    extends GenericVisitorAdapter<Void, Map<AccessibleObject, String[]>> {
        private final StringBuilder currentClassName = new StringBuilder();
        private String packageName;

        private MethodParametersVisitor() {
        }

        public Void visit(ClassOrInterfaceDeclaration n, Map<AccessibleObject, String[]> arg) {
            this.currentClassName.append("$").append(n.getName());
            super.visit(n, arg);
            this.currentClassName.delete(this.currentClassName.length() - n.getName().length() - 1, this.currentClassName.length());
            return null;
        }

        public Void visit(ConstructorDeclaration n, Map<AccessibleObject, String[]> arg) {
            Constructor<?> c = this.findConstructor(n);
            String[] paramNames = this.extractParameterNames(n.getParameters());
            arg.put(c, paramNames);
            return (Void)super.visit(n, arg);
        }

        public Void visit(MethodDeclaration n, Map<AccessibleObject, String[]> arg) {
            Method m = this.findMethod(n);
            String[] paramNames = this.extractParameterNames(n.getParameters());
            arg.put(m, paramNames);
            return (Void)super.visit(n, arg);
        }

        public Void visit(PackageDeclaration n, Map<AccessibleObject, String[]> arg) {
            this.packageName = n.getName().toString();
            return (Void)super.visit(n, arg);
        }

        private boolean argsMatch(Class<?>[] parameterTypes, List<Parameter> parameters) {
            if (parameters == null) {
                return parameterTypes.length == 0;
            }
            if (parameters.size() != parameterTypes.length) {
                return false;
            }
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> paramType = parameterTypes[i];
                Parameter param = parameters.get(i);
                if (paramType.getSimpleName().equals(param.getType().toString())) continue;
                return false;
            }
            return true;
        }

        private String[] extractParameterNames(List<Parameter> parameters) {
            int length = parameters == null ? 0 : parameters.size();
            String[] params = new String[length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = parameters.get(i).getId().getName();
            }
            return params;
        }

        private Constructor<?> findConstructor(ConstructorDeclaration n) {
            Class<?> currentVisitedClass = this.getCurrentVisitedClass();
            for (Constructor<?> constructor : currentVisitedClass.getDeclaredConstructors()) {
                if (!this.argsMatch(constructor.getParameterTypes(), n.getParameters())) continue;
                return constructor;
            }
            return null;
        }

        private Method findMethod(MethodDeclaration n) {
            Class<?> currentVisitedClass = this.getCurrentVisitedClass();
            for (Method method : currentVisitedClass.getDeclaredMethods()) {
                if (!method.getName().equals(n.getName()) || !this.argsMatch(method.getParameterTypes(), n.getParameters())) continue;
                return method;
            }
            return null;
        }

        private Class<?> getCurrentVisitedClass() {
            String className = this.packageName + "." + this.currentClassName.substring(1);
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new ParameterNamesNotFoundException("Error while trying to retrieve class " + className + " :", (Exception)e);
            }
        }
    }

    public static interface JavaFileFinder {
        public InputStream openJavaFile(AccessibleObject var1);
    }
}

