/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.configuration;

import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.mockito.Mock;
import org.mockito.configuration.AnnotationEngine;
import org.mockito.configuration.GwtMockAnnotationProcessor;
import org.mockito.configuration.GwtMockScanner;
import org.mockito.configuration.GwtSpyAnnotationEngine;
import org.mockito.configuration.MockitoMockAnnotationProcessor;
import org.mockito.internal.configuration.DefaultAnnotationEngine;
import org.mockito.internal.configuration.DefaultInjectionEngine;
import org.mockito.internal.configuration.FieldAnnotationProcessor;
import org.mockito.internal.configuration.injection.scanner.InjectMocksScanner;
import org.mockito.internal.util.collections.Sets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GwtInjectingAnnotationEngine
implements AnnotationEngine {
    private final AnnotationEngine delegate = new DefaultAnnotationEngine();
    private final AnnotationEngine spyAnnotationEngine;

    public GwtInjectingAnnotationEngine() {
        this.registerAnnotationProcessor(com.googlecode.gwt.test.Mock.class, new GwtMockAnnotationProcessor());
        this.registerAnnotationProcessor(Mock.class, new MockitoMockAnnotationProcessor());
        this.spyAnnotationEngine = new GwtSpyAnnotationEngine();
    }

    @Deprecated
    public Object createMockFor(Annotation annotation, Field field) {
        return this.delegate.createMockFor(annotation, field);
    }

    public void injectMocks(Object testClassInstance) {
        HashSet mockDependentFields = new HashSet();
        Set mocks = Sets.newMockSafeHashSet((Object[])new Object[0]);
        for (Class<?> clazz = testClassInstance.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            new InjectMocksScanner(clazz).addTo(mockDependentFields);
            new GwtMockScanner(testClassInstance, clazz).addPreparedMocks(mocks);
        }
        new DefaultInjectionEngine().injectMocksOnFields(mockDependentFields, mocks, testClassInstance);
    }

    public void process(Class<?> clazz, Object testInstance) {
        this.processIndependentAnnotations(testInstance.getClass(), testInstance);
        this.processInjectMocks(testInstance.getClass(), testInstance);
    }

    protected <A extends Annotation> void registerAnnotationProcessor(Class<A> annotationClass, FieldAnnotationProcessor<A> fieldAnnotationProcessor) {
        GwtReflectionUtils.callPrivateMethod((Object)this.delegate, "registerAnnotationProcessor", annotationClass, fieldAnnotationProcessor);
    }

    private void processIndependentAnnotations(Class<?> clazz, Object testInstance) {
        for (Class<?> classContext = clazz; classContext != Object.class; classContext = classContext.getSuperclass()) {
            this.delegate.process(classContext, testInstance);
            this.spyAnnotationEngine.process(classContext, testInstance);
        }
    }

    private void processInjectMocks(Class<?> clazz, Object testInstance) {
        for (Class<?> classContext = clazz; classContext != Object.class; classContext = classContext.getSuperclass()) {
            this.injectMocks(testInstance);
        }
    }
}

