/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.util.Iterator;
import org.fest.util.AbstractComparisonStrategy;
import org.fest.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardComparisonStrategy
extends AbstractComparisonStrategy {
    private static final StandardComparisonStrategy INSTANCE = new StandardComparisonStrategy();

    public static StandardComparisonStrategy instance() {
        return INSTANCE;
    }

    private StandardComparisonStrategy() {
    }

    @Override
    public boolean areEqual(Object actual, Object other) {
        return Objects.areEqual(actual, other);
    }

    @Override
    public boolean iterableContains(Iterable<?> iterable, Object value) {
        if (iterable == null) {
            return false;
        }
        for (Object next : iterable) {
            if (!Objects.areEqual(next, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void iterableRemoves(Iterable<?> iterable, Object value) {
        if (iterable == null) {
            return;
        }
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            if (!Objects.areEqual(iterator.next(), value)) continue;
            iterator.remove();
        }
    }

    @Override
    public Iterable<?> duplicatesFrom(Iterable<?> iterable) {
        return super.duplicatesFrom(iterable);
    }

    @Override
    public boolean stringStartsWith(String string, String prefix) {
        return string.startsWith(prefix);
    }

    @Override
    public boolean stringEndsWith(String string, String suffix) {
        return string.endsWith(suffix);
    }

    @Override
    public boolean stringContains(String string, String sequence) {
        return string.contains(sequence);
    }

    @Override
    public boolean isGreaterThan(Object actual, Object other) {
        if (!Comparable.class.isAssignableFrom(actual.getClass())) {
            throw new IllegalArgumentException(String.format("argument '%s' should be Comparable but is not", actual));
        }
        if (!Comparable.class.isAssignableFrom(other.getClass())) {
            throw new IllegalArgumentException(String.format("argument '%s' should be Comparable but is not", other));
        }
        Comparable comparableActual = (Comparable)actual;
        Comparable comparableOther = (Comparable)other;
        return comparableActual.compareTo(comparableOther) > 0;
    }
}

