/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client.storage;

import com.calpano.common.client.storage.SingleKeyStorage;
import org.xydra.base.Base;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.rmof.XReadableModel;
import org.xydra.base.rmof.impl.XExistsRevWritableModel;
import org.xydra.core.model.impl.memory.IMemoryModel;
import org.xydra.core.model.impl.memory.MemoryModel;
import org.xydra.core.model.impl.memory.sync.MemorySyncLog;
import org.xydra.core.model.impl.memory.sync.XSyncLogState;
import org.xydra.core.serialize.SerializedModel;
import org.xydra.core.serialize.XydraElement;
import org.xydra.core.serialize.XydraOut;
import org.xydra.core.serialize.json.JsonParser;
import org.xydra.core.serialize.json.JsonSerializer;

public class MemoryModelStorage
extends SingleKeyStorage<IMemoryModel> {
    private final XId actorId;
    private final String keyPrefix;
    private final XId repoId;
    private final String passwordHash;

    public MemoryModelStorage(XId actorId, XId repoId, String passwordHash, String keyPrefix) {
        this.actorId = actorId;
        this.repoId = repoId;
        this.passwordHash = passwordHash;
        this.keyPrefix = keyPrefix;
    }

    @Override
    public String getKey() {
        return this.keyPrefix + "_" + this.actorId;
    }

    @Override
    protected String serialize(IMemoryModel model) {
        JsonSerializer serializer = new JsonSerializer();
        XydraOut out = serializer.create();
        out.enableWhitespace(false, false);
        SerializedModel.serialize((XReadableModel)model, (XydraOut)out, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        String data = out.getData();
        assert (this.deserialize(data) != null);
        return data;
    }

    @Override
    protected MemoryModel deserialize(String data) {
        JsonParser parser = new JsonParser();
        XydraElement xydraElement = parser.parse(data);
        XExistsRevWritableModel model = SerializedModel.toModelState((XydraElement)xydraElement, (XAddress)Base.resolveRepository((XId)this.repoId));
        MemorySyncLog syncLogState = new MemorySyncLog(model.getAddress());
        XydraElement syncLogElement = xydraElement.getChild("synclog");
        SerializedModel.loadSyncLogState((XydraElement)syncLogElement, (XSyncLogState)syncLogState.getSyncLogState());
        MemoryModel memoryModel = new MemoryModel(this.actorId, this.passwordHash, model, syncLogState.getSyncLogState());
        return memoryModel;
    }
}

