/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client.view.forms.suggestion.impl;

import com.calpano.common.client.ClientApp;
import com.calpano.common.client.util.SuggestionDisplay;
import com.calpano.common.client.view.forms.impl.IKeyboardAndValueEventHandler;
import com.calpano.common.client.view.forms.suggestion.HasHideSuggestionHandlers;
import com.calpano.common.client.view.forms.suggestion.HasShowSuggestionHandlers;
import com.calpano.common.client.view.forms.suggestion.HideSuggestionEvent;
import com.calpano.common.client.view.forms.suggestion.HideSuggestionHandler;
import com.calpano.common.client.view.forms.suggestion.ISuggestionDisplay;
import com.calpano.common.client.view.forms.suggestion.ShowSuggestionEvent;
import com.calpano.common.client.view.forms.suggestion.ShowSuggestionHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextBoxBase;
import org.xydra.annotations.LicenseApache;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

@LicenseApache(project="SuggestBox", copyright="Copyright 2009 Google Inc.")
public class SuggestionManager
implements HasSelectionHandlers<SuggestOracle.Suggestion>,
HasEnabled,
HasShowSuggestionHandlers,
HasHideSuggestionHandlers,
IKeyboardAndValueEventHandler {
    private static Logger log = LoggerFactory.getLogger(SuggestionManager.class);
    private final TextBoxBase textboxbase;
    private int limit = 20;
    private boolean selectsFirstItem = true;
    private final SuggestOracle oracle;
    private String currentText;
    private final ISuggestionDisplay display;
    private final SuggestOracle.Callback callback = new SuggestOracle.Callback(){

        public void onSuggestionsReady(SuggestOracle.Request request, SuggestOracle.Response response) {
            if (!SuggestionManager.this.isEnabled()) {
                return;
            }
            if (response.getSuggestions().size() > 0) {
                ShowSuggestionEvent.fire(SuggestionManager.this.getTextBoxBase());
            }
            SuggestionManager.this.display.showSuggestions(SuggestionManager.this, response.getSuggestions(), SuggestionManager.this.isAutoSelectEnabled(), SuggestionManager.this.suggestionCallback, response.hasMoreSuggestions(), response.getMoreSuggestionsCount());
        }
    };
    private final SuggestionCallback suggestionCallback = new SuggestionCallback(){

        @Override
        public void onSuggestionSelected(SuggestOracle.Suggestion suggestion) {
            SuggestionManager.this.setNewSelection(suggestion);
        }
    };
    private boolean enabled = true;
    private HandlerManager handlerManager;

    public SuggestionManager(SuggestOracle oracle, TextBoxBase textBoxBase, SuggestionDisplay suggestionDisplay) {
        this.oracle = oracle;
        this.display = suggestionDisplay;
        this.textboxbase = textBoxBase;
    }

    public int getLimit() {
        return this.limit;
    }

    public SuggestOracle getSuggestOracle() {
        return this.oracle;
    }

    public boolean isAutoSelectEnabled() {
        return this.selectsFirstItem;
    }

    public void setAutoSelectEnabled(boolean selectsFirstItem) {
        this.selectsFirstItem = selectsFirstItem;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void showSuggestions(String query) {
        log.trace("Show suggestions for '" + query + "'");
        assert (this.oracle != null);
        if (query.length() == 0) {
            this.oracle.requestDefaultSuggestions(new SuggestOracle.Request(null, this.limit), this.callback);
        } else {
            this.oracle.requestSuggestions(new SuggestOracle.Request(query, this.limit), this.callback);
        }
    }

    private void fireSuggestionEvent(SuggestOracle.Suggestion selectedSuggestion) {
        SelectionEvent.fire((HasSelectionHandlers)this, (Object)selectedSuggestion);
    }

    private void refreshSuggestions(String text) {
        if (text.equals(this.currentText)) {
            return;
        }
        this.currentText = text;
        this.showSuggestions(text);
    }

    private void setNewSelection(SuggestOracle.Suggestion curSuggestion) {
        assert (curSuggestion != null) : "suggestion cannot be null";
        this.currentText = curSuggestion.getReplacementString();
        this.textboxbase.setText(this.currentText);
        this.hideSuggestions();
        this.fireSuggestionEvent(curSuggestion);
    }

    public void fireEvent(GwtEvent<?> event) {
        this.ensureHandlers().fireEvent(event);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<SuggestOracle.Suggestion> handler) {
        return this.ensureHandlers().addHandler(SelectionEvent.getType(), handler);
    }

    protected HandlerManager createHandlerManager() {
        return new HandlerManager((Object)this);
    }

    HandlerManager ensureHandlers() {
        return this.handlerManager == null ? (this.handlerManager = this.createHandlerManager()) : this.handlerManager;
    }

    public TextBoxBase getTextBoxBase() {
        return this.textboxbase;
    }

    public void fireSuggestionActivated(SuggestOracle.Suggestion s) {
        this.hideSuggestions();
        this.textboxbase.setText(s.getReplacementString());
    }

    @Override
    public com.google.web.bindery.event.shared.HandlerRegistration addShowSuggestionHandler(ShowSuggestionHandler handler) {
        return ClientApp.getEventBus().addHandlerToSource(ShowSuggestionEvent.TYPE, (Object)this.getTextBoxBase(), (Object)handler);
    }

    @Override
    public com.google.web.bindery.event.shared.HandlerRegistration addHideSuggestionHandler(HideSuggestionHandler handler) {
        return ClientApp.getEventBus().addHandlerToSource(HideSuggestionEvent.TYPE, (Object)this.getTextBoxBase(), (Object)handler);
    }

    @Override
    public void onBrowserEvent(Event event) {
        switch (event.getTypeInt()) {
            case 128: {
                switch (event.getKeyCode()) {
                    case 40: {
                        this.display.moveSelectionDown();
                        break;
                    }
                    case 38: {
                        this.display.moveSelectionUp();
                        break;
                    }
                    case 9: 
                    case 13: {
                        SuggestOracle.Suggestion suggestion = this.display.getCurrentSelection();
                        if (suggestion == null) {
                            this.hideSuggestions();
                            break;
                        }
                        this.setNewSelection(suggestion);
                    }
                }
                break;
            }
            case 4096: {
                if (event.getTypeInt() != 4096) break;
                new Timer(){

                    public void run() {
                        SuggestionManager.this.hideSuggestions();
                    }
                }.schedule(150);
            }
        }
    }

    private void hideSuggestions() {
        HideSuggestionEvent.fire(this.textboxbase);
        this.display.hideSuggestions();
    }

    public void onValueChange(ValueChangeEvent<String> event) {
        this.refreshSuggestions((String)event.getValue());
    }

    public void reset() {
        this.hideSuggestions();
    }

    public static interface SuggestionCallback {
        public void onSuggestionSelected(SuggestOracle.Suggestion var1);
    }
}

