/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.csv;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import org.xydra.csv.IRow;
import org.xydra.csv.ISparseTable;
import org.xydra.csv.TableCoreTools;
import org.xydra.csv.impl.memory.Row;

public class HtmlTool {
    public static final ICellRenderer identityCellRenderer = new ICellRenderer(){

        @Override
        public String html(String cellContent) {
            return HtmlTool.htmlencode(cellContent);
        }
    };

    public static void writeToHtml(ISparseTable table, String sortColName, Writer w) throws IOException {
        HtmlTool.writeToHtml(table, sortColName, w, identityCellRenderer);
    }

    public static void writeToHtml(ISparseTable table, String sortColName, Writer w, ICellRenderer cellRenderer) throws IOException {
        w.write("<table class='csv'>\n");
        w.write("<tr>");
        ArrayList<String> colNames = new ArrayList<String>();
        colNames.addAll(table.getColumnNames());
        Collections.sort(colNames);
        for (String colName : colNames) {
            w.write("<th>" + HtmlTool.htmlencode(colName) + "</th>");
        }
        w.write("</tr>\n");
        Iterable<Row> rows = table;
        if (sortColName != null) {
            rows = TableCoreTools.sortByColumn(table, sortColName);
        }
        for (IRow row : rows) {
            w.write("<tr>");
            for (String colName : colNames) {
                String value = row.getValue(colName);
                value = cellRenderer.html(value);
                w.write("<td>" + value + "</td>");
            }
            w.write("</tr>\n");
        }
        w.write("</table>\n");
    }

    public static String htmlencode(String s) {
        return s.replace("&", "&apos;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;");
    }

    public static interface ICellRenderer {
        public String html(String var1);
    }
}

