/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.csv.impl.memory;

import java.io.IOException;
import org.xydra.csv.IRowHandler;
import org.xydra.csv.impl.memory.Row;
import org.xydra.csv.impl.memory.SparseTable;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class CsvCoreTable
extends SparseTable
implements Iterable<Row> {
    private static Logger log = LoggerFactory.getLogger(CsvCoreTable.class);
    protected static final String COLUMNNAME_ROW = "ROW";
    protected String defaultEncoding = "ISO-8859-1";
    protected boolean splitWhenWritingLargeFiles = false;
    protected int readMaxRows = -1;

    static String latexEncode(String s, int fieldLength) {
        String s2 = s;
        if (s == null) {
            s2 = "";
        } else if (s.equals("null")) {
            s2 = "";
        }
        while (s2.length() < fieldLength) {
            s2 = " " + s2;
        }
        return s2;
    }

    public CsvCoreTable() {
    }

    public CsvCoreTable(boolean maintainColumnInsertionOrder) {
        super(maintainColumnInsertionOrder);
    }

    public void setParamReadMaxRows(int readMaxRows) {
        this.readMaxRows = readMaxRows;
    }

    public void setParamSplitWhenWritingLargeFiles(boolean b) {
        this.splitWhenWritingLargeFiles = b;
    }

    public void writeTo(IRowHandler rowHandler) throws IOException {
        rowHandler.handleHeaderRow(this.getColumnNames());
        for (String rowName : this.rowNamesIterable()) {
            Row row = this.getOrCreateRow(rowName, false);
            rowHandler.handleRow(rowName, row);
        }
    }
}

