/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe;

import de.xam.texthtml.text.TextTool;
import de.xam.tokenpipe.IToken;
import java.util.ArrayList;
import java.util.Map;
import org.xydra.index.impl.trie.SortedArrayMap;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class Token
implements IToken {
    private static final Logger log = LoggerFactory.getLogger(Token.class);
    private String chars;
    private Map<String, String> context;
    private IToken.Kind kind;
    private IToken source;
    private IToken startToken;
    private String type;

    @SafeVarargs
    public static Token create(IToken.Kind kind, String type, String chars, Pair<String, String> ... context) {
        Token token = new Token();
        token.kind = kind;
        token.type = type;
        token.chars = chars;
        token.context = new SortedArrayMap(1);
        for (Pair<String, String> p : context) {
            token.context.put(((String)p.getFirst()).intern(), (String)p.getSecond());
        }
        return token;
    }

    private Token() {
    }

    @Override
    public void addContext(String key, String value) {
        this.context.put(key, value);
    }

    @Override
    public String getChars() {
        return this.chars;
    }

    @Override
    public int getContextAsInt(String key) throws IllegalStateException {
        String value = this.context.get(key);
        if (value == null) {
            log.debug("found no key '" + key + "' in token " + this);
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean getContextAsBoolean(String key) {
        String value = this.context.get(key);
        if (value == null) {
            log.debug("found no key '" + key + "' in token " + this);
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    @Override
    public Map<String, String> getContextAsMap() {
        return this.context;
    }

    @Override
    @SafeVarargs
    public final Pair<String, String>[] getContextAsPairsAndAdd(Pair<String, String> ... pairs) {
        ArrayList<Object> all = new ArrayList<Object>();
        for (Pair<String, String> pair : pairs) {
            all.add(pair);
        }
        for (Map.Entry<String, String> e : this.context.entrySet()) {
            all.add(new Pair((Object)e.getKey(), (Object)e.getValue()));
        }
        return all.toArray(new Pair[0]);
    }

    @Override
    public String getContextAsString(String key, String defaultValue) {
        assert (key != null);
        String val = this.context.get(key);
        return val == null ? defaultValue : val;
    }

    @Override
    public IToken.Kind getKind() {
        return this.kind;
    }

    @Override
    public IToken getSource() {
        return this.source;
    }

    @Override
    public IToken getStartToken() {
        assert (this.isEnd() == (this.startToken != null));
        return this.startToken;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isContent() {
        return this.getKind() == IToken.Kind.Content;
    }

    @Override
    public boolean isEnd() {
        return this.getKind() == IToken.Kind.End;
    }

    @Override
    public boolean isStart() {
        return this.getKind() == IToken.Kind.Start;
    }

    @Override
    public int length() {
        return this.getChars() == null ? -1 : this.getChars().length();
    }

    @Override
    public void setSource(IToken source) {
        assert (this != source);
        assert (source != null);
        this.source = source;
    }

    @Override
    public void setStartToken(IToken startToken) {
        assert (startToken != null);
        assert (this != startToken);
        assert (this.isEnd());
        this.startToken = startToken;
    }

    @Override
    public String toString() {
        return this.toString(-1, true);
    }

    @Override
    public String toString(int maxContentLen, boolean realLineBreaks) {
        String content = TextTool.toLimitedString((Object)this.getChars(), (int)maxContentLen);
        StringBuilder buf = new StringBuilder();
        switch (this.kind) {
            case Start: {
                buf.append("<");
                buf.append(this.type);
                if (content == null) break;
                buf.append(" start='");
                buf.append(TextTool.foldLineBreaks((String)content));
                buf.append("'");
                break;
            }
            case End: {
                buf.append("</" + this.type);
                if (content == null) break;
                buf.append(" end='" + TextTool.foldLineBreaks((String)content) + "'");
                break;
            }
            case Content: {
                buf.append("<CONTENT-" + this.type + ">");
                if (!realLineBreaks) {
                    buf.append(TextTool.foldLineBreaks((String)content));
                } else {
                    buf.append(content);
                }
                buf.append("</ CONTENT-" + this.type);
            }
        }
        for (Map.Entry<String, String> e : this.context.entrySet()) {
            buf.append(" " + e.getKey() + "='" + e.getValue() + "'");
        }
        buf.append(">");
        if (this.source != null) {
            buf.append("\n                     SOURCE=[" + this.source.toString(maxContentLen, realLineBreaks) + "]");
        }
        return buf.toString();
    }
}

