/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe;

import de.xam.tokenpipe.ITokenPipe;
import de.xam.tokenpipe.ITokenSink;
import de.xam.tokenpipe.ITokenSource;
import de.xam.tokenpipe.Parsers;
import de.xam.tokenpipe.TokenPipeStack;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class TokenPipeParser {
    private static final Logger log = LoggerFactory.getLogger(TokenPipeParser.class);
    private final TokenPipeStack stack = new TokenPipeStack();

    public void parse(Reader r, Object parseContext) throws IOException {
        try {
            this.stack.parse(r, parseContext);
        }
        catch (Error | Exception e) {
            log.warn("Parse problems at " + parseContext);
            throw e;
        }
    }

    public void configurePipes(ITokenSink sink, ITokenPipe ... tokenPipes) {
        this.stack.stack(sink, tokenPipes);
    }

    public void validate() {
        Parsers.validate(this);
    }

    public ITokenSource getSource() {
        return this.stack.getSource();
    }

    public void dumpConfig(File file) throws IOException {
        this.stack.dumpConfig(file);
    }

    public void dumpHistory() {
        this.stack.dumpHistory();
    }

    public void dump() {
        this.stack.dump();
    }

    public void dumpStats() {
        this.stack.dumpStats();
    }
}

