/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.impl;

import de.xam.texthtml.text.TextTool;
import de.xam.tokenpipe.IToken;
import java.io.IOException;
import java.io.Writer;
import org.xydra.core.serialize.xml.XmlEncoder;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

class HtmlLogSink {
    private static final Logger log = LoggerFactory.getLogger(HtmlLogSink.class);
    private final String debugName;
    boolean isFinished;
    private final Writer w;

    public HtmlLogSink(Writer w, String debugName) {
        this.w = w;
        this.debugName = debugName;
    }

    private void addToLine(String s) {
        try {
            this.w.write(s);
        }
        catch (IOException e) {
            try {
                this.w.flush();
            }
            catch (IOException e1) {
                log.warn("could not flush", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    public void debug(String msg) {
        if (!this.isFinished) {
            this.line("<debug>" + XmlEncoder.encode((String)msg) + "</debug>");
        } else {
            this.line("<!--" + XmlEncoder.encode((String)msg).replace("-", "...-...") + " -->");
        }
    }

    public void exceptionAndFinish(String msg, Throwable e) {
        assert (e != null);
        this.debug("<pre>" + e.toString() + "\n" + "</pre>");
        log.warn("exception", e);
        this.finishLogFile();
    }

    private void finishLogFile() {
        if (!this.isFinished) {
            this.line("</log>");
            try {
                this.w.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.isFinished = true;
            log.debug("Finished log " + this.getDebugName());
        }
    }

    public void fireToken(IToken token, String action) {
        log.debug("FIRE-from-" + this.getDebugName() + " = " + token.toString(20, false));
        this.tokenAsXml("  ", token, "out", "fire");
    }

    private String getDebugName() {
        return this.debugName;
    }

    public void ignoreAndPassThrough(IToken token) {
        this.tokenAsXml("", token, "out", "IgnoreAndPassThrough");
    }

    private void line(String s) {
        try {
            this.w.write(s);
            this.w.write("\n");
        }
        catch (IOException e) {
            try {
                this.w.flush();
            }
            catch (IOException e1) {
                log.warn("could not flush", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    public void onAfterContentToken(IToken token) {
    }

    public void onAfterDocument() {
        this.finishLogFile();
    }

    public void onBeforeContentToken(IToken token) {
        this.line("<!-- (((   (((   (((   (((   (((   (((    -->");
    }

    public void onBeforeDocument() {
        this.line("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.line("<?xml-stylesheet type='text/xsl' href='xml-to-html.xsl'?>");
        this.line("<log>");
        this.line("<!-- Open in FireFox to see XSLT applied. Chrome doesn't do it. -->");
        this.isFinished = false;
    }

    public void onToken(IToken token) {
        log.debug(TextTool.padRight((String)"_", (String)this.getDebugName(), (int)12) + ": onToken " + token.toString(30, false));
        this.tokenAsXml("", token, "in", "on");
    }

    public void parseException(String msg, IToken token, int pos, int codepoint) {
        this.line("<exception>");
        this.line("<msg>" + msg + "</msg>");
        this.line("<pos>" + pos + "</pos>");
        this.line("<codepoint>" + codepoint + "</codepoint>");
        this.line("<token>");
        this.tokenAsXml("", token, "in", "Exception");
        this.line("</token>");
        this.line("</exception>");
    }

    private void tokenAsXml(String indent, IToken token, String dir, String role) {
        StringBuilder atts = new StringBuilder();
        for (Pair<String, String> p : token.getContextAsPairsAndAdd(new Pair((Object)"type", (Object)token.getType()), new Pair((Object)"kind", (Object)token.getKind().toString()), new Pair((Object)"dir", (Object)dir), new Pair((Object)"role", (Object)role))) {
            atts.append(" ");
            atts.append((String)p.getFirst());
            atts.append("='");
            atts.append((String)p.getSecond());
            atts.append("'");
        }
        if (!token.isContent() && token.length() > 0) {
            atts.append(" chars='");
            atts.append(token.getChars());
            atts.append("'");
        }
        this.addToLine(indent);
        switch (token.getKind()) {
            case Start: 
            case End: {
                this.addToLine("<");
                this.addToLine(token.getKind().toString());
                this.addToLine(atts.toString());
                this.addToLine("/>");
                this.line("");
                break;
            }
            case Content: {
                String tagName = token.getKind().name();
                String content = XmlEncoder.encode((String)token.getChars());
                content = content.replace("\n", "|BR|");
                this.addToLine("<");
                this.addToLine(tagName);
                this.addToLine(atts.toString());
                this.addToLine(">");
                if (token.length() > 20) {
                    this.line("");
                }
                this.addToLine(content);
                this.addToLine("</");
                this.addToLine(tagName);
                this.addToLine(">");
                this.line("");
            }
        }
    }
}

