/*
 * Decompiled with CFR 0.152.
 */
package de.xam.itemset.impl;

import com.google.common.collect.Ordering;
import com.google.web.bindery.event.shared.Event;
import com.google.web.bindery.event.shared.EventBus;
import de.xam.cds.CdsId;
import de.xam.cmodel.content.CBrowserRenderableContent;
import de.xam.cmodel.content.IContentType;
import de.xam.cmodel.fact.CTriple;
import de.xam.cmodel.fact.ChangeDatas;
import de.xam.cmodel.fact.IChangeData;
import de.xam.cmodel.fact.impl.ChangeDataImpl;
import de.xam.cmodel.util.CUtils;
import de.xam.itemset.Attributes;
import de.xam.itemset.CDS;
import de.xam.itemset.IEntity;
import de.xam.itemset.IItem;
import de.xam.itemset.IItemSet;
import de.xam.itemset.IProperty;
import de.xam.itemset.IStatement;
import de.xam.itemset.VocabularyItemSet;
import de.xam.itemset.event.AttributeEvent;
import de.xam.itemset.event.ItemEvent;
import de.xam.itemset.event.PropertyEvent;
import de.xam.itemset.event.PropertySourceEvent;
import de.xam.itemset.event.StatementEvent;
import de.xam.itemset.event.StatementSourceEvent;
import de.xam.itemset.impl.ItemSetRemovableTripleSinkAdapter;
import de.xam.itemset.impl.Items;
import de.xam.itemset.impl.LexicographicItemComparator;
import de.xam.p13n.shared.time.TimeProvider;
import de.xam.texthtml.text.TextTool;
import de.xam.vocabulary.Vocabulary;
import de.xam.vocabulary.VocabularyTerm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xydra.base.Base;
import org.xydra.base.XId;
import org.xydra.base.value.ValueType;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;
import org.xydra.core.XX;
import org.xydra.core.model.delta.AtomicChangeType;
import org.xydra.core.util.RegExUtil;
import org.xydra.index.ITripleIndex;
import org.xydra.index.ITripleSink;
import org.xydra.index.impl.TripleUtils;
import org.xydra.index.iterator.ITransformer;
import org.xydra.index.iterator.Iterators;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class ItemSets {
    private static final Logger log = LoggerFactory.getLogger(ItemSets.class);
    private static final Comparator<IItem> comparator_lexicographically = new Comparator<IItem>(){

        @Override
        public int compare(IItem a, IItem b) {
            return a.getDisplayString().compareTo(b.getDisplayString());
        }
    };
    private static final Comparator<IEntity> comparator_changeDate = new Comparator<IEntity>(){

        @Override
        public int compare(IEntity a, IEntity b) {
            long changeDateB;
            long changeDateA = Items.getChangeDateUTC(a);
            long delta = changeDateA - (changeDateB = Items.getChangeDateUTC(b));
            if (delta > 0L) {
                return 1;
            }
            if (delta < 0L) {
                return -1;
            }
            return a.getId().compareTo((Object)b.getId());
        }
    };
    public static final String AUTHOR_SYSTEM = "_system";

    public static void addRelated(IItemSet itemSet, XId sourceItemId, XId relationId, XId targetId, IChangeData changeData) {
        XId stmtId = Base.createUniqueId();
        itemSet.createAndAddStatement(stmtId, sourceItemId, relationId, targetId, changeData);
    }

    public static boolean removeRelated(IItemSet itemSet, XId id, XId relationId, XId targetId, IChangeData changeData) {
        Set<IStatement> stmts = itemSet.getStatementsFor(id, relationId, targetId);
        for (IStatement stmt : stmts) {
            itemSet.deleteStatement(stmt.getId(), changeData);
        }
        return !stmts.isEmpty();
    }

    public static boolean hasRelated(IItemSet itemSet, XId id, XId relationId, XId targetId) {
        return itemSet.getTripleIndex().getTriples((Object)id, (Object)relationId, (Object)targetId).hasNext();
    }

    public static Iterator<XId> getRelatedBy(IItemSet itemSet, XId id, XId relationId) {
        Iterator it = itemSet.getTripleIndex().getTriples((Object)id, (Object)relationId, null);
        ITransformer transformer = TripleUtils.transformer_o();
        return Iterators.transform((Iterator)it, (ITransformer)transformer);
    }

    public static boolean isUsedInStatements(IItemSet itemSet, XId entityId) {
        return itemSet.getTripleIndex().contains((Object)entityId, null, null) || itemSet.getTripleIndex().contains(null, (Object)entityId, null) || itemSet.getTripleIndex().contains(null, null, (Object)entityId);
    }

    public static XValue getPropertyValue(IItemSet itemSet, XId sourceEntityId, XId propertyKey) {
        IProperty property = ItemSets.getProperty(itemSet, sourceEntityId, propertyKey);
        if (property == null) {
            return null;
        }
        assert (property.getWritableContent().getContentValue() != null);
        return property.getPropertyValue();
    }

    public static IProperty getProperty(IItemSet itemSet, XId sourceEntityId, XId propertyKey) {
        Set<IProperty> props = itemSet.getPropertiesFor(sourceEntityId, propertyKey);
        if (props.isEmpty()) {
            return null;
        }
        if (props.size() > 1) {
            throw new AssertionError((Object)("props.size > 1 for '" + sourceEntityId + "." + propertyKey + "', " + props));
        }
        IProperty prop = props.iterator().next();
        return prop;
    }

    public static void fireAttributeUpdate(EventBus eventbus, XId entityId, XId attributeId, XValue oldValue, XValue newValue) {
        AttributeEvent event = new AttributeEvent(entityId, attributeId, oldValue, newValue);
        eventbus.fireEvent((Event)event);
        eventbus.fireEventFromSource((Event)event, (Object)attributeId);
    }

    public static void fireContentUpdate(EventBus eventbus, XId itemId, CBrowserRenderableContent oldContent, CBrowserRenderableContent newContent) {
        ItemEvent event = new ItemEvent(itemId, oldContent, newContent);
        eventbus.fireEvent((Event)event);
        eventbus.fireEventFromSource((Event)event, (Object)itemId);
    }

    public static void firePropertyEvent(EventBus eventbus, IProperty property, AtomicChangeType changeType, CBrowserRenderableContent oldContent, CBrowserRenderableContent newContent) {
        assert (property.getWritableContent().getContentValue() != null);
        PropertyEvent pe = new PropertyEvent(property, changeType, oldContent, newContent);
        if (log.isTraceEnabled()) {
            log.trace("fire " + (Object)((Object)pe));
        }
        eventbus.fireEvent((Event)pe);
        XId s = property.getSourceEntityId();
        XId p = property.getPropertyKey();
        PropertySourceEvent pse = new PropertySourceEvent(property, changeType, oldContent, newContent);
        eventbus.fireEventFromSource((Event)pse, (Object)s);
        eventbus.fireEventFromSource((Event)pse, (Object)p);
    }

    public static void fireStatementEvent(EventBus eventbus, IStatement statement, AtomicChangeType changeType) {
        XId s = statement.getTriple().s();
        XId p = statement.getTriple().p();
        XId o = statement.getTriple().o();
        if (log.isTraceEnabled()) {
            log.trace("fire " + changeType + "(" + s + "," + p + "," + o + ")");
        }
        StatementEvent se = new StatementEvent(statement, changeType);
        eventbus.fireEvent((Event)se);
        StatementSourceEvent sse = new StatementSourceEvent(statement, changeType);
        eventbus.fireEventFromSource((Event)sse, (Object)s);
        eventbus.fireEventFromSource((Event)sse, (Object)p);
        eventbus.fireEventFromSource((Event)sse, (Object)o);
    }

    public static boolean setProperty(IItemSet itemSet, XId sourceEntityId, XId propertyKey, XValue propertyValue, IChangeData changeData) {
        IProperty prop = ItemSets.getProperty(itemSet, sourceEntityId, propertyKey);
        if (propertyValue == null) {
            if (prop != null) {
                assert (prop.getWritableContent().getContentValue() != null);
                return itemSet.deleteProperty(prop.getId(), changeData);
            }
            return false;
        }
        if (prop == null) {
            XId propertyId = Base.createUniqueId();
            prop = itemSet.createAndAddProperty(propertyId, sourceEntityId, propertyKey, propertyValue, changeData);
            return true;
        }
        assert (prop.getWritableContent().getContentValue() != null);
        return prop.setPropertyValue(propertyValue, changeData);
    }

    public static String abbreviate(String fullUri, Map<String, String> namespaceMap, String nsSep) {
        for (Map.Entry<String, String> entry : namespaceMap.entrySet()) {
            String expansion = entry.getValue();
            if (!fullUri.startsWith(expansion)) continue;
            String ns = entry.getKey();
            return ns + nsSep + fullUri.substring(expansion.length());
        }
        return null;
    }

    public static IItem getOrCreateItemWithStringContent(IItemSet itemSet, XId itemId, String contentString, IChangeData changeData) {
        IItem item = itemSet.getItemById(itemId);
        if (item == null) {
            item = contentString == null ? itemSet.getOrCreateAndAddItem(itemId, changeData) : ItemSets.createItemWithStringContent(itemSet, itemId, contentString, changeData);
        } else if (contentString != null) {
            Items.setContentString(item, contentString, ChangeDatas.getLastCreationOrModifiedDate((IChangeData)changeData));
        }
        return item;
    }

    public static IItem createItemWithContent(IItemSet itemSet, XId itemId, String content, IContentType contentType, IChangeData changeData) {
        assert (content != null);
        IItem item = itemSet.getOrCreateAndAddItem(itemId, changeData);
        item.getWritableContent().setContent(content, contentType.getUri(), ChangeDatas.getLastCreationOrModifiedDate((IChangeData)changeData));
        return item;
    }

    public static IItem createItemWithStringContent(IItemSet itemSet, XId itemId, String content, IChangeData changeData) {
        assert (content != null);
        IItem item = itemSet.getOrCreateAndAddItem(itemId, changeData);
        long changeDate = ChangeDatas.getLastCreationOrModifiedDate((IChangeData)changeData);
        item.getWritableContent().setContent((XValue)XV.toValue((String)content), changeDate);
        return item;
    }

    public static void deleteEntity(IItemSet itemSet, XId entityId, IChangeData changeData) {
        IEntity entity = itemSet.getEntityById(entityId);
        if (entity == null) {
            return;
        }
        if (entity instanceof IStatement) {
            IStatement stmt = (IStatement)entity;
            itemSet.deleteStatement(stmt.getId(), changeData);
        } else if (entity instanceof IProperty) {
            IProperty property = (IProperty)entity;
            assert (property.getWritableContent().getContentValue() != null);
            itemSet.deleteProperty(property.getId(), changeData);
        } else {
            assert (entity instanceof IItem);
            itemSet.deleteItem(entityId, changeData);
        }
    }

    public static Comparator<? super XId> createItemIdComparator_content(final IItemSet myBase) {
        Ordering comparator = Ordering.allEqual().compound((Comparator)new Comparator<XId>(){

            @Override
            public int compare(XId a, XId b) {
                assert (a != null);
                assert (b != null);
                String aContent = Items.getDisplayString(myBase, a);
                String bContent = Items.getDisplayString(myBase, b);
                if (aContent == null) {
                    if (bContent == null) {
                        return a.compareTo((Object)b);
                    }
                    return 1;
                }
                if (bContent == null) {
                    return -1;
                }
                return TextTool.compare((String)aContent, (String)bContent, (boolean)false);
            }
        });
        return comparator;
    }

    public static Comparator<? super IItem> createItemComparator_content() {
        Ordering comparator = Ordering.allEqual().compound((Comparator)new LexicographicItemComparator());
        return comparator;
    }

    public static void addVocabularyAsBuilttins(IItemSet itemSet, Vocabulary voc, IChangeData changeData) {
        for (VocabularyTerm term : voc.terms()) {
            ItemSets.createItemWithStringContent(itemSet, term.id(), term.getLabel(), changeData);
        }
    }

    public static String expandNamespace(String shortUri, Map<String, String> namespaceMap, String nsSep) {
        assert (shortUri != null);
        String[] parts = shortUri.split(RegExUtil.regexEncode((String)nsSep));
        if (parts.length == 2) {
            String expansion = namespaceMap.get(parts[0]);
            if (expansion == null) {
                log.warn("Found no namespace expansion, uri='" + shortUri + "'");
            }
            return expansion + parts[1];
        }
        String defaultExpansion = namespaceMap.get("");
        if (defaultExpansion == null) {
            log.warn("Found no default namespace mapped to ''");
            return shortUri;
        }
        return defaultExpansion + shortUri;
    }

    public static String getContent(IItemSet itemSet, XId itemId) {
        assert (itemId != null);
        IItem item = itemSet.getItemById(itemId);
        if (item == null) {
            return "[" + itemId.toString() + "]";
        }
        return item.getDisplayString();
    }

    public static Map<String, String> getNamespaces(IItemSet itemSet) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator attIdIt = itemSet.attributes();
        while (attIdIt.hasNext()) {
            XId attId = (XId)attIdIt.next();
            XValue attValue = itemSet.getAttribute(attId);
            assert (attValue.getType() == ValueType.String);
            map.put(attId.toString().substring("namespace-".length()), attValue.toString());
        }
        return map;
    }

    public static List<IItem> itemsIndex(IItemSet itemSet) {
        Iterator it = itemSet.items();
        ArrayList<IItem> list = new ArrayList<IItem>(1024);
        Iterators.addAll((Iterator)it, list);
        ItemSets.sortLexicographicallyByContent(list);
        return list;
    }

    public static List<IEntity> entitiesList(IItemSet itemSet) {
        ArrayList<IEntity> list = new ArrayList<IEntity>(1024);
        for (XId id : itemSet) {
            IEntity entity = itemSet.getEntityById(id);
            list.add(entity);
        }
        return list;
    }

    public static void sortByChangeDate(List<IEntity> list) {
        Collections.sort(list, comparator_changeDate);
    }

    public static void sortLexicographicallyByContent(List<IItem> list) {
        Collections.sort(list, comparator_lexicographically);
    }

    public static List<IItem> sortByContent(Iterator<IItem> it) {
        ArrayList list = Iterators.toArrayList(it);
        Collections.sort(list, ItemSets.createItemComparator_content());
        return list;
    }

    public static List<XId> sortByItemContent(IItemSet myBase, Iterator<XId> itemIdIterator) {
        ArrayList list = Iterators.toArrayList(itemIdIterator);
        Collections.sort(list, ItemSets.createItemIdComparator_content(myBase));
        return list;
    }

    public static void registerNamespace(IItemSet itemSet, String ns, String expansion) {
        itemSet.setAttribute(Base.toId((String)("namespace-" + ns)), (XValue)XV.toValue((String)expansion));
    }

    public static Iterator<IItem> toItems(final IItemSet itemSet, Iterator<XId> itemIdIt) {
        assert (itemIdIt != null);
        return Iterators.transform(itemIdIt, (ITransformer)new ITransformer<XId, IItem>(){

            public IItem transform(XId id) {
                IItem item = itemSet.getItemById(id);
                if (item == null) {
                    throw new IllegalArgumentException("Iterator contained itemId '" + id + "' for which no item was found.");
                }
                return item;
            }
        });
    }

    public static IItem createRelation(IItemSet itemSet, XId superRelation, String idString, String label, IChangeData changeData) {
        XId relId = Base.toId((String)idString);
        IItem relItem = itemSet.getOrCreateAndAddItem(relId, changeData);
        Items.setContentString(relItem, label, ChangeDatas.getLastCreationOrModifiedDate((IChangeData)changeData));
        if (superRelation != null) {
            ItemSets.addRelated(itemSet, relId, (XId)CDS.INSTANCE.hasSuperType, superRelation, changeData);
        }
        return relItem;
    }

    public static int size(IItemSet itemSet) {
        return Iterators.count(itemSet.iterator());
    }

    public static String toDisplayString(IItemSet itemSet, XId itemId) {
        IItem item = itemSet.getItemById(itemId);
        if (item == null) {
            return itemId.toString();
        }
        assert (item != null) : "itemid=" + itemId;
        return item.getDisplayString();
    }

    public static void addBuiltinItems(IItemSet itemSet) {
        IChangeData changeData = ChangeDatas.createWithCreationDate_Now((String)AUTHOR_SYSTEM, (String)"builtin-cds");
        ItemSets.createCdsBuiltin(CdsId.hasInverse, itemSet, changeData);
        ItemSets.createCdsBuiltin(CdsId.hasType, itemSet, changeData);
        ItemSets.createCdsBuiltin(CdsId.hasSubType, itemSet, changeData);
        for (CdsId cdsId : CdsId.values()) {
            ItemSets.createCdsBuiltin(cdsId, itemSet, changeData);
        }
    }

    public static void addCdsAxioms(IItemSet itemSet) {
        log.info("Adding CDS axioms");
        HashMap<XId, XValue> attributes = new HashMap<XId, XValue>();
        attributes.put(VocabularyItemSet.ATTRIBUTE_ACCESS_IS_DELETE_PROTECTED, (XValue)XV.toValue((boolean)true));
        ItemSetRemovableTripleSinkAdapter adapter = ItemSetRemovableTripleSinkAdapter.create(itemSet, AUTHOR_SYSTEM, "InfModelXy", attributes);
        CDS.INSTANCE.addAxiomaticTriples((ITripleSink)adapter);
        log.info("Done adding CDS axioms ----------------------------------------------------------------------");
    }

    public static void addCdsAxioms(ITripleIndex<XId, XId, XId> tripleIndex) {
        log.info("Adding CDS axioms to tripleIndex");
        CDS.INSTANCE.addAxiomaticTriples(tripleIndex);
        log.info("Done adding CDS axioms ----------------------------------------------------------------------");
    }

    public static void deleteBuiltinItems(IItemSet itemSet) {
        HashSet<XId> found = new HashSet<XId>();
        for (XId id : itemSet) {
            IEntity entity = itemSet.getEntityById(id);
            IChangeData changeData = entity.getChangeData();
            String createdBy = changeData.getCreatedBy();
            if (!createdBy.equals(AUTHOR_SYSTEM)) continue;
            found.add(id);
        }
        IChangeData cd = ChangeDatas.createWithLastModifiedDate_Now((String)AUTHOR_SYSTEM, (String)"ItemSets-deleteBuiltins");
        for (XId id : found) {
            ItemSets.deleteEntity(itemSet, id, cd);
        }
    }

    private static void createCdsBuiltin(CdsId cdsId, IItemSet itemSet, IChangeData changeData) {
        assert (itemSet != null);
        XId id = CDS.getXId(cdsId);
        String content = cdsId.getLabel();
        IItem item = itemSet.getItemById(id);
        if (item != null) {
            return;
        }
        item = ItemSets.createItemWithStringContent(itemSet, id, content, changeData);
        Items.setIsDeleteProtected(item, true);
        if (cdsId.isRelation()) {
            XId relId = id;
            XId hasType = (XId)CDS.INSTANCE.hasType;
            XId typeRelation = (XId)CDS.INSTANCE.type_relation;
            XId stmtId = CUtils.combine((XId)relId, (XId)hasType, (XId)typeRelation);
            itemSet.createAndAddStatement(stmtId, relId, hasType, typeRelation, changeData);
        }
    }

    public static void replaceItemId(IItemSet itemSet, XId oldId, XId newId) {
        long now = TimeProvider.getCurrentTimeInMillis();
        IChangeData changeDataNow = ChangeDatas.createWithLastModifiedDate_Now((String)AUTHOR_SYSTEM, (String)"replaceItemId");
        IItem oldItem = itemSet.getItemById(oldId);
        if (oldItem == null) {
            return;
        }
        ChangeDataImpl changeData = ChangeDatas.clone((IChangeData)oldItem.getChangeData());
        changeData.setLastModifiedUTC(now);
        IItem newItem = itemSet.getOrCreateAndAddItem(newId, oldItem.getChangeData());
        Attributes.copyAttributes(oldItem, newItem);
        CBrowserRenderableContent content = oldItem.getContent();
        newItem.getWritableContent().setContent(content, now);
        Set<IProperty> props = itemSet.getPropertiesFor(oldId, null);
        for (IProperty p : props) {
            itemSet.createAndAddProperty(p.getId(), newId, p.getPropertyKey(), p.getPropertyValue(), ChangeDatas.cloneLastModifiedNow((IChangeData)p.getChangeData()));
        }
        Set<IStatement> oxx = itemSet.getStatementsFor(oldId, null, null);
        for (IStatement stmt : oxx) {
            CTriple t = stmt.getTriple();
            itemSet.createAndAddStatement(XX.createUniqueId(), newId, t.p(), t.o(), ChangeDatas.cloneLastModifiedNow((IChangeData)stmt.getChangeData()));
        }
        Set<IStatement> xox = itemSet.getStatementsFor(null, oldId, null);
        for (IStatement stmt : xox) {
            CTriple t = stmt.getTriple();
            itemSet.createAndAddStatement(XX.createUniqueId(), t.s(), newId, t.o(), ChangeDatas.cloneLastModifiedNow((IChangeData)stmt.getChangeData()));
        }
        Set<IStatement> xxo = itemSet.getStatementsFor(null, null, oldId);
        for (IStatement stmt : xxo) {
            CTriple t = stmt.getTriple();
            itemSet.createAndAddStatement(XX.createUniqueId(), t.s(), t.p(), newId, ChangeDatas.cloneLastModifiedNow((IChangeData)stmt.getChangeData()));
        }
        ItemSets.deleteItemId(itemSet, oldId, changeDataNow);
    }

    public static void deleteItemId(IItemSet itemSet, XId itemId, IChangeData changeData) {
        Set<IProperty> props = itemSet.getPropertiesFor(itemId, null);
        for (IProperty p : props) {
            itemSet.deleteProperty(p.getId(), changeData);
        }
        Set<IStatement> oxx = itemSet.getStatementsFor(itemId, null, null);
        for (IStatement stmt : oxx) {
            itemSet.deleteStatement(stmt.getId(), changeData);
        }
        Set<IStatement> xox = itemSet.getStatementsFor(null, itemId, null);
        for (IStatement stmt : xox) {
            itemSet.deleteStatement(stmt.getId(), changeData);
        }
        Set<IStatement> xxo = itemSet.getStatementsFor(null, null, itemId);
        for (IStatement stmt : xxo) {
            itemSet.deleteStatement(stmt.getId(), changeData);
        }
        itemSet.deleteItem(itemId, changeData);
    }
}

