/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.content;

import de.xam.cmodel.content.AbstractContentType;
import de.xam.cmodel.content.IContentType;
import de.xam.cmodel.content.IanaContentType;
import org.xydra.index.IPair;

public class XsdContentType
extends AbstractContentType
implements IContentType {
    public static final String PREFIX_IANA_CONTENTTYPE_XSD = "w3c.xsd.";
    private static final String PREFIX_XSD_SCHEMA_URI = "http://www.w3.org/2001/XMLSchema#";
    public static final XsdContentType XSD_BOOLEAN = new XsdContentType("boolean", true);
    public static final XsdContentType XSD_DOUBLE = new XsdContentType("double", true);
    public static final XsdContentType XSD_INT = new XsdContentType("int", true);
    public static final XsdContentType XSD_STRING = new XsdContentType("string", true);
    private String ianaContentTypeString;
    private String uri;
    private final String xsdTypeName;

    private static boolean isXsdStringType(String xsdSchemaType) {
        return xsdSchemaType.equals("string") || xsdSchemaType.equals("anyURI") || xsdSchemaType.equals("QName") || xsdSchemaType.equals("NOTATION");
    }

    public static boolean isXsdUri(String contentTypeUri) {
        return contentTypeUri.startsWith(PREFIX_XSD_SCHEMA_URI);
    }

    public static XsdContentType parseXsdUri(String contentTypeUri) {
        assert (XsdContentType.isXsdUri(contentTypeUri));
        String localName = contentTypeUri.substring(PREFIX_XSD_SCHEMA_URI.length());
        boolean isStringType = XsdContentType.isXsdStringType(localName);
        XsdContentType result = new XsdContentType(localName, isStringType);
        return result;
    }

    public static String toDataTypeUri(XsdContentType xsdContentType) {
        return PREFIX_XSD_SCHEMA_URI + xsdContentType.getNativeString();
    }

    public static IanaContentType toIanaContentType(XsdContentType xsdContentType) {
        if (xsdContentType.equals(XSD_STRING)) {
            return IanaContentType.TEXT_PLAIN;
        }
        return new IanaContentType(IanaContentType.IanaRegistrationTree.VendorTree, IanaContentType.IanaTopLevelTypeName.Application, PREFIX_IANA_CONTENTTYPE_XSD, false, new IPair[0]);
    }

    public XsdContentType(String xsdTypeName, boolean isStringType) {
        super(AbstractContentType.TypeSystem.XsdSchema, isStringType);
        assert (xsdTypeName != null);
        this.xsdTypeName = xsdTypeName;
    }

    @Override
    public String getAsIanaContentTypeString() {
        if (this.ianaContentTypeString == null) {
            this.ianaContentTypeString = XsdContentType.toIanaContentType(this).getAsIanaContentTypeString();
        }
        return this.ianaContentTypeString;
    }

    @Override
    public String getNativeString() {
        return this.xsdTypeName;
    }

    @Override
    public String getUri() {
        if (this.uri == null) {
            this.uri = XsdContentType.toDataTypeUri(this);
        }
        return this.uri;
    }
}

