/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.fact;

import de.xam.cmodel.content.CBrowserRenderableContent;
import de.xam.cmodel.content.Contents;
import de.xam.cmodel.fact.CEntity;
import de.xam.cmodel.fact.CFact;
import de.xam.cmodel.fact.CFactIndex;
import de.xam.cmodel.fact.CFactSink;
import de.xam.cmodel.fact.CFactSource;
import de.xam.cmodel.fact.CSymbol;
import de.xam.cmodel.fact.CTriple;
import de.xam.texthtml.text.TextTool;
import java.util.Iterator;
import org.xydra.base.XId;

public class FactSets {
    public static void copy(CFactSource source, CFactSink sink) {
        Iterator<CEntity> it = source.getEntities();
        while (it.hasNext()) {
            CEntity entity = it.next();
            sink.addEntity(entity);
        }
    }

    public static String toString(CFactIndex factIndex, XId id) {
        CFact fact = factIndex.getFactById(id);
        if (fact == null) {
            return id.toString();
        }
        assert (fact != null);
        if (fact instanceof CSymbol) {
            return FactSets.toString((CSymbol)fact);
        }
        assert (fact instanceof CTriple);
        return id.toString() + "[triple]";
    }

    private static String toString(CSymbol symbol) {
        if (symbol.isReference()) {
            return "[" + symbol.toString() + "]";
        }
        CBrowserRenderableContent content = symbol.getContent();
        if (Contents.isStringContent(content)) {
            String s = content.getContentAsString();
            return symbol.getId().toString() + "='" + TextTool.toLimitedString((Object)s, (int)100) + "'";
        }
        return symbol.getId().toString() + "[" + content.getContentTypeUri() + "]";
    }

    public static String toString(CFactIndex factIndex, CTriple t) {
        String s = FactSets.toString(factIndex, t.s());
        String p = FactSets.toString(factIndex, t.p());
        String o = FactSets.toString(factIndex, t.o());
        return "(" + s + ", " + p + ", " + o + ")";
    }
}

