/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.fact.impl.mem;

import de.xam.cmodel.content.CBrowserRenderableContent;
import de.xam.cmodel.content.CWritableBrowserRenderableContent;
import de.xam.cmodel.content.ContentTypes;
import de.xam.cmodel.fact.CSymbol;
import de.xam.cmodel.fact.CSymbolIndex;
import de.xam.cmodel.fact.CSymbolSink;
import de.xam.cmodel.fact.CSymbolSource;
import de.xam.cmodel.fact.impl.ReferenceValues;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xydra.base.XId;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class MemorySymbolSet
implements CSymbolSource,
CSymbolSink,
CSymbolIndex {
    private final XId id;
    private final Map<XId, CSymbol> symbols = new HashMap<XId, CSymbol>();
    private static final Logger log = LoggerFactory.getLogger(MemorySymbolSet.class);
    private final ReferenceValues<CBrowserRenderableContent> contentReferences = new ReferenceValues();

    public MemorySymbolSet(XId id) {
        this.id = id;
    }

    public XId getId() {
        return this.id;
    }

    @Override
    public Iterator<CSymbol> getSymbols() {
        return this.symbols.values().iterator();
    }

    @Override
    public String dump() {
        log.info("symbolMap.size = " + this.symbols.size());
        for (Map.Entry<XId, CSymbol> e : this.symbols.entrySet()) {
            log.info(e.getKey() + " --> '" + e.getValue() + "'" + (e.getValue().isReference() ? "[ID]" : ""));
        }
        return "";
    }

    public void searchAndReplaceInStringValues(String search, String replace) {
        for (CSymbol symbol : this.symbols.values()) {
            String r;
            String s;
            CWritableBrowserRenderableContent content = symbol.getWritableContent();
            String contentTypeUri = content.getContentTypeUri();
            if (!ContentTypes.isStringType(contentTypeUri) || (s = content.getContentAsString()).equals(r = s.replace(search, replace))) continue;
            content.setContent(s, contentTypeUri, -1L);
        }
    }

    @Override
    public String toDebugString() {
        return "TODO";
    }

    @Override
    public void addSymbol(CSymbol symbol) {
        if (symbol.isReference()) {
            this.contentReferences.addReferenceValue(symbol.getId(), symbol.getContent());
        }
        this.symbols.put(symbol.getId(), symbol);
    }

    @Override
    public void removeSymbol(CSymbol symbol) {
        if (symbol.isReference()) {
            this.contentReferences.removeReferenceValue(symbol.getContent());
        }
        this.symbols.remove(symbol.getId());
    }

    @Override
    public CSymbol getSymbolById(XId symbolId) {
        return this.symbols.get(symbolId);
    }

    @Override
    public void removeSymbol(XId symbolId) {
        this.symbols.remove(symbolId);
    }
}

