/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.service;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.xydra.core.util.RegExUtil;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.log.impl.universal.UniversalLogger;

public class ContentTypePattern {
    private static final Logger log = LoggerFactory.getLogger(ContentTypePattern.class);
    private final Set<Pattern> patterns = new HashSet<Pattern>();

    public void addPattern(String pattern) {
        this.patterns.add(ContentTypePattern.toRegex(pattern));
    }

    public static Pattern toRegex(String pattern) {
        String low = pattern.toLowerCase();
        String literal = RegExUtil.regexEncode((String)low);
        String star = literal.replace("\\*", ".*");
        return Pattern.compile(star);
    }

    public boolean matches(String contentTypeUri) {
        for (Pattern p : this.patterns) {
            boolean isMatch = p.matcher(contentTypeUri).matches();
            log.info("Cond: '" + p.toString() + "' Test: '" + contentTypeUri + "' => " + isMatch);
            if (!isMatch) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        UniversalLogger.activate();
        ContentTypePattern condition = new ContentTypePattern();
        condition.addPattern("application/*+xml");
        assert (!condition.matches("image/png"));
        assert (condition.matches("application/xhtml+xml"));
        ContentTypePattern action = new ContentTypePattern();
        action.addPattern("application/*");
        assert (condition.matches(action)) : "if 'application/*' is produced, 'application/*+xml' might also be produced";
        assert (action.matches(condition)) : "if 'application/*+xml' is produced, 'application/*' should match";
        ContentTypePattern action2 = new ContentTypePattern();
        action2.addPattern("application/octet-stream");
        assert (!condition.matches(action2)) : "if 'application/octet-stream' is produced, 'application/*+xml' cannot be produced";
        assert (!action2.matches(condition)) : "if 'application/*+xml' is produced, 'octet-stream' should not match";
    }

    public boolean matches(ContentTypePattern actionPattern) {
        boolean isMatch;
        for (Pattern action : actionPattern.getPatterns()) {
            for (Pattern condition : this.patterns) {
                isMatch = condition.matcher(action.toString()).matches();
                log.info("Cond: '" + condition.toString() + "' Test: '" + action.toString() + "' => " + isMatch);
                if (!isMatch) continue;
                return true;
            }
        }
        for (Pattern condition : this.getPatterns()) {
            for (Pattern action : actionPattern.getPatterns()) {
                isMatch = action.matcher(condition.toString()).matches();
                log.info("Cond: '" + action.toString() + "' Test: '" + condition.toString() + "' => " + isMatch);
                if (!isMatch) continue;
                return true;
            }
        }
        return false;
    }

    private Set<Pattern> getPatterns() {
        return this.patterns;
    }

    public boolean isEmpty() {
        return this.patterns.isEmpty();
    }
}

