/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.service;

import de.xam.cmodel.fact.CEntity;
import de.xam.cmodel.fact.CFact;
import de.xam.cmodel.fact.CFactSet;
import de.xam.cmodel.fact.CSymbol;
import de.xam.cmodel.fact.CTriple;
import de.xam.cmodel.fact.impl.CombinedFactSet;
import de.xam.cmodel.service.COptimizedService;
import de.xam.cmodel.service.CService;
import de.xam.cmodel.service.ContentTypePattern;
import de.xam.cmodel.service.ServiceUtils;
import de.xam.texthtml.text.HumanReadableText;
import de.xam.triplerules.ITriplePattern;
import de.xam.triplerules.impl.InferenceEngine;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.xydra.base.XId;
import org.xydra.core.util.Clock;
import org.xydra.index.Factory;
import org.xydra.index.IEntrySet;
import org.xydra.index.impl.FastEntrySetFactory;
import org.xydra.index.impl.MapSetIndex;
import org.xydra.index.iterator.Iterators;
import org.xydra.index.query.Constraint;
import org.xydra.index.query.ITriple;
import org.xydra.index.query.KeyEntryTuple;
import org.xydra.index.query.Wildcard;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class ServiceEngine {
    private static final Logger log = LoggerFactory.getLogger(ServiceEngine.class);
    private final Set<COptimizedService> services = new HashSet<COptimizedService>();
    private boolean servicesAreCompiled = false;
    private Set<CService> activeServices = new HashSet<CService>();
    private Set<CService> matchedServices = new HashSet<CService>();
    private final MapSetIndex<CService, CService> serviceDependencies = new MapSetIndex((Factory)new FastEntrySetFactory());
    private int processedInputTriples = 0;
    private int inferredTriples = 0;
    private long reportingThreshold = 1000L;

    public void addService(COptimizedService service) {
        this.services.add(service);
        this.servicesAreCompiled = false;
    }

    private void activateServices(CService matchedService) {
        IEntrySet otherServices = this.serviceDependencies.lookup((Object)matchedService);
        if (otherServices != null) {
            for (CService other : otherServices) {
                if (this.activeServices.contains(matchedService)) continue;
                this.activeServices.add(other);
                this.activateServices(other);
            }
        }
    }

    private synchronized void ensureCompiledServices() {
        if (this.servicesAreCompiled) {
            return;
        }
        this.compileServices();
    }

    private void compileServices() {
        for (COptimizedService service : this.services) {
            service.compile();
            for (COptimizedService otherService : this.services) {
                if (!ServiceUtils.couldTrigger(service, otherService)) continue;
                this.serviceDependencies.index((Object)service, (Object)otherService);
            }
        }
        if (log.isDebugEnabled()) {
            Iterator it = this.serviceDependencies.tupleIterator((Constraint)new Wildcard(), (Constraint)new Wildcard());
            while (it.hasNext()) {
                KeyEntryTuple tuple = (KeyEntryTuple)it.next();
                log.debug("Service triggers " + ((CService)tuple.getFirst()).label() + " -> " + ((CService)tuple.getSecond()).label());
            }
        }
        this.servicesAreCompiled = true;
    }

    public void inferAll(CFactSet source, CFactSet target) {
        this.ensureCompiledServices();
        log.info("[0=iteration.x=serviceNumber] ==================== Initial iteration from all triples...");
        HashSet<CFact> startInf = new HashSet<CFact>();
        int serviceNo = 1;
        for (COptimizedService service : this.services) {
            Set tp;
            ContentTypePattern cp;
            if (log.isDebugEnabled()) {
                log.debug("[0." + serviceNo + "=service] Processing service '" + service.label() + "' (Service " + serviceNo + " of " + this.services.size() + ")");
            }
            if (!(cp = service.condition().contentPattern()).isEmpty()) {
                Iterator<CSymbol> symbolIt = source.getSymbols();
                while (symbolIt.hasNext()) {
                    CSymbol symbol = symbolIt.next();
                    String contentTypeUri = symbol.getContent().getContentTypeUri();
                    if (!cp.matches(contentTypeUri)) continue;
                    service.processSymbol(symbol, startInf);
                }
            }
            if (!(tp = service.condition().triplePattern().patterns()).isEmpty()) {
                Iterator<CTriple> tripleIt = source.getTriples();
                while (tripleIt.hasNext()) {
                    CTriple triple = tripleIt.next();
                    if (!ServiceEngine.matches(tp, triple)) continue;
                    service.processTriple(triple, startInf);
                }
            }
            ++serviceNo;
        }
        log.info("==================== Done: Initial iteration from all triples. Inferred " + startInf.size() + " triples");
        CombinedFactSet combined = new CombinedFactSet(source, target);
        this.activeServices.addAll(this.services);
        this.inferLoop(startInf, combined, target);
    }

    public static boolean matches(Set<ITriplePattern<XId, XId, XId>> tp, CTriple triple) {
        for (ITriplePattern<XId, XId, XId> pattern : tp) {
            if (!InferenceEngine.matches(pattern, (ITriple)triple)) continue;
            return true;
        }
        return false;
    }

    private void inferLoop(Collection<CFact> startInf, CFactSet source, CFactSet target) {
        int iteration = 1;
        Collection<CFact> newInf = startInf;
        while (!newInf.isEmpty()) {
            for (CFact fact : newInf) {
                target.addFact(fact);
            }
            Collection<CFact> lastInf = newInf;
            log.debug("==================== Infer iteration #" + iteration + "; lastInf.size=" + lastInf.size());
            newInf = this.inferOneIteration(lastInf, source, iteration);
            ++iteration;
        }
        assert (newInf.size() == 0) : "newInf is empty, nothing to commit";
    }

    public void inferIncrementalFromFact(CFactSet source, CFact fact, CFactSet target) {
        this.ensureCompiledServices();
        CombinedFactSet combined = new CombinedFactSet(source, target);
        this.activeServices.addAll(this.services);
        HashSet<CFact> startInf = new HashSet<CFact>();
        startInf.add(fact);
        this.inferLoop(startInf, combined, target);
    }

    private Collection<CFact> inferOneIteration(Collection<? extends CFact> lastInf, CFactSet tripleIndex, int iteration) {
        if (log.isDebugEnabled()) {
            for (CService service : this.matchedServices) {
                log.debug("### Service matched: " + service.label());
            }
            for (CService service : this.activeServices) {
                log.debug("### Active service: " + service.label());
            }
        }
        if (log.isDebugEnabled()) {
            Iterator<CEntity> it = tripleIndex.getEntities();
            int count = Iterators.count(it);
            log.debug("Fact base contains " + HumanReadableText.largeNumber((long)count) + " facts. Last inf = " + HumanReadableText.largeNumber((long)lastInf.size()) + " facts.");
        }
        HashSet<CFact> newInf = new HashSet<CFact>();
        for (COptimizedService cOptimizedService : this.services) {
            if (!this.activeServices.contains(cOptimizedService)) {
                log.debug("There cannot be a match for service " + cOptimizedService.label() + "");
                continue;
            }
            this.inferOneIteration_OneService(cOptimizedService, lastInf, tripleIndex, iteration, newInf);
        }
        this.activeServices = new HashSet<CService>();
        for (CService cService : this.matchedServices) {
            this.activateServices(cService);
        }
        this.matchedServices = new HashSet<CService>();
        return newInf;
    }

    private void inferOneIteration_OneService(COptimizedService service, Collection<? extends CFact> lastInf, CFactSet model, int iteration, Collection<CFact> newInf) {
        if (log.isDebugEnabled()) {
            log.debug("> Running service '" + service.label() + "' on " + lastInf.size() + " triples                     ");
        }
        int inferredByThisService = 0;
        Clock clock = new Clock().start();
        for (CFact cFact : lastInf) {
            ++this.processedInputTriples;
            if ((long)this.processedInputTriples % this.reportingThreshold == 0L) {
                this.reportingThreshold *= 2L;
                log.info(">> Processed " + HumanReadableText.largeNumber((long)this.processedInputTriples) + " input triples. Inferred  " + HumanReadableText.largeNumber((long)this.inferredTriples) + " triples");
                long millis = clock.stopAndGetDuration("triples");
                clock.start();
                log.debug("Millis = " + millis);
            }
            if (log.isDebugEnabled()) {
                log.debug(">> Processing fact " + cFact);
            }
            inferredByThisService += this.inferOneIteration_OneService_OneFact(service, cFact, model, newInf, iteration);
        }
        this.inferredTriples += inferredByThisService;
        if (log.isDebugEnabled() && inferredByThisService > 0) {
            log.debug("> Service '" + service.label() + "' inferred " + inferredByThisService + " triples");
        }
        if (log.isDebugEnabled() && newInf.size() > 0 && iteration > 1) {
            log.debug("> Total NewInf.size = " + newInf.size());
        }
    }

    public void markServiceAsMatched(CService service) {
        this.matchedServices.add(service);
    }

    public void dumpServices() {
        TreeMap<String, CService> map = new TreeMap<String, CService>();
        for (CService cService : this.services) {
            map.put(cService.label(), cService);
        }
        StringBuilder b = new StringBuilder();
        for (Map.Entry e : map.entrySet()) {
            b.append(((CService)e.getValue()).toString());
        }
        log.info("\n" + b.toString());
    }

    public int inferOneIteration_OneService_OneFact(COptimizedService service, CFact fact, CFactSet model, Collection<CFact> newInf, int iteration) {
        int inferred = 0;
        if (service.condition().matches(fact)) {
            if (log.isTraceEnabled()) {
                log.trace(">>> Condition " + service.condition() + " matches " + fact);
            }
            this.markServiceAsMatched(service);
            inferred += service.processFact(fact, model, newInf);
        }
        return inferred;
    }
}

