/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.service;

public enum ServiceState {
    starting,
    running,
    stopping,
    stopped;

    private ServiceState[] nextStates;

    public boolean isActive() {
        return this != stopped;
    }

    public boolean shouldRun() {
        return this == starting || this == running;
    }

    public ServiceState goTo(ServiceState nextState) {
        if (!this.mayGoTo(nextState)) {
            throw new IllegalStateException("Cannot go from state [" + (Object)((Object)this) + "] to [" + (Object)((Object)nextState) + "]");
        }
        return nextState;
    }

    public boolean mayGoTo(ServiceState nextState) {
        if (this == nextState) {
            return true;
        }
        for (ServiceState next : this.nextStates) {
            if (next != nextState) continue;
            return true;
        }
        return false;
    }

    public static ServiceState initial() {
        return stopped;
    }

    public boolean mayStart() {
        return this == stopped;
    }

    public boolean isStarting() {
        return this == starting;
    }

    public boolean shouldStop() {
        return this == stopping;
    }

    public boolean isInactive() {
        return !this.isActive();
    }

    public boolean isRunning() {
        return this == running;
    }

    static {
        ServiceState.starting.nextStates = new ServiceState[]{running, stopping, stopped};
        ServiceState.running.nextStates = new ServiceState[]{stopping, stopped};
        ServiceState.stopping.nextStates = new ServiceState[]{stopped};
        ServiceState.stopped.nextStates = new ServiceState[]{starting, running};
    }
}

