/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.util;

import de.xam.cmodel.content.CBrowserRenderableContent;
import de.xam.cmodel.fact.CEntity;
import de.xam.cmodel.fact.CFactSet;
import de.xam.cmodel.fact.CFactSource;
import de.xam.cmodel.fact.CSymbol;
import de.xam.cmodel.fact.CTriple;
import de.xam.cmodel.fact.IChangeData;
import de.xam.cmodel.fact.impl.mem.MemoryFactory;
import de.xam.cmodel.util.CUtils;
import de.xam.vocabulary.Vocabulary;
import de.xam.vocabulary.VocabularyTerm;
import java.util.Iterator;
import org.xydra.base.XId;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;

public class VocabularyUtils {

    public static class VocabularyFactSource
    implements CFactSource {
        private final IChangeData changeDate;
        private final CFactSet factSet;
        private final Vocabulary voc;

        public VocabularyFactSource(Vocabulary voc, IChangeData changeData) {
            this.voc = voc;
            this.changeDate = changeData;
            MemoryFactory factory = new MemoryFactory();
            this.factSet = factory.createFactSet(this.getId());
            for (VocabularyTerm term : voc.terms()) {
                CSymbol symbol = CUtils.createAndAddStringSymbolWithId(factory, this.factSet, term.id(), term.getLabel());
                if (term.isDeprecated()) {
                    // empty if block
                }
                CBrowserRenderableContent content = factory.contentFactory().createValueContent((XValue)XV.toValue((String)term.getLabel()));
                factory.createSymbol(term.id(), content, false);
            }
        }

        public XId getId() {
            return this.voc.id();
        }

        @Override
        public IChangeData getChangeData() {
            return this.changeDate;
        }

        @Override
        public String dump() {
            this.voc.dump();
            return "";
        }

        @Override
        public String toDebugString() {
            return this.voc.toString();
        }

        @Override
        public CFactSource getContextModel() {
            return null;
        }

        @Override
        public Iterator<CTriple> getTriples() {
            return null;
        }

        @Override
        public Iterator<CSymbol> getSymbols() {
            return null;
        }

        @Override
        public Iterator<CEntity> getEntities() {
            return null;
        }
    }
}

