/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.gwt;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.xydra.base.Base;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.change.XCommand;
import org.xydra.base.change.XRepositoryCommand;
import org.xydra.base.change.impl.memory.MemoryRepositoryCommand;
import org.xydra.core.DemoModelUtil;
import org.xydra.core.LoggerTestHelper;
import org.xydra.core.change.XTransactionBuilder;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.store.XydraStore;
import org.xydra.store.XydraStoreAdmin;
import org.xydra.store.access.XA;
import org.xydra.store.access.XAuthenticationDatabase;
import org.xydra.store.access.XAuthorisationManager;

public class TestServer {
    private static final Logger log = TestServer.getLogger();
    private final int port;
    private Server server;
    private WebAppContext webapp;

    private static Logger getLogger() {
        LoggerTestHelper.init();
        return LoggerFactory.getLogger(TestServer.class);
    }

    public TestServer() {
        this(8080);
    }

    public TestServer(int port) {
        this.port = port;
    }

    public URI startServer(String contextPath, File docRoot) {
        log.info("Starting server with docRoot=" + docRoot.getAbsolutePath() + " contextPaht=" + contextPath);
        if (this.server != null) {
            throw new RuntimeException("server is already startet");
        }
        this.server = new Server(this.port);
        this.webapp = new WebAppContext(docRoot.getAbsolutePath(), contextPath);
        this.server.setHandler((Handler)this.webapp);
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            return new URI("http://localhost:" + this.port + "/").resolve(contextPath + "/");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void stopServer() {
        if (this.server != null) {
            try {
                this.server.stop();
                this.server.destroy();
            }
            catch (Exception e) {
                throw new RuntimeException("error stopping server", e);
            }
            this.server = null;
        }
    }

    public XydraStore getStore() {
        if (this.webapp == null) {
            throw new RuntimeException("cannot get backend before server is started");
        }
        ContextHandler.Context sc = this.webapp.getServletContext();
        return (XydraStore)sc.getAttribute("org.xydra.store");
    }

    public static void main(String[] args) throws Exception {
        new TestServer().startXydraServer(new File("src/main/webapp"));
    }

    public URI startXydraServer(File webapp) {
        URI uri = this.startServer("/xydra", webapp);
        XydraStore store = this.getStore();
        assert (store != null);
        XydraStoreAdmin admin = store.getXydraStoreAdmin();
        XAuthenticationDatabase auth = admin.getAccessControlManager().getAuthenticationDatabase();
        XId actorId = Base.toId((String)"tester");
        String passwordHash = "secret";
        auth.setPasswordHash(actorId, "secret");
        XAuthorisationManager access = admin.getAccessControlManager().getAuthorisationManager();
        XAddress repoAddr2 = Base.toAddress((XId)admin.getRepositoryId(), null, null, null);
        access.getAuthorisationDatabase().setAccess(actorId, repoAddr2, XA.ACCESS_READ, true);
        access.getAuthorisationDatabase().setAccess(actorId, repoAddr2, XA.ACCESS_WRITE, true);
        XRepositoryCommand createCommand2 = MemoryRepositoryCommand.createAddCommand((XAddress)repoAddr2, (long)-11L, (XId)DemoModelUtil.PHONEBOOK_ID);
        XAddress modelAddr2 = createCommand2.getChangedEntity();
        XTransactionBuilder tb2 = new XTransactionBuilder(modelAddr2);
        DemoModelUtil.setupPhonebook((XAddress)modelAddr2, (XTransactionBuilder)tb2, (boolean)true);
        store.executeCommands(actorId, "secret", new XCommand[]{createCommand2, tb2.buildCommand()}, null);
        log.info("Started embedded Jetty server. User interface is at " + uri.toString());
        return uri;
    }
}

