/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.htmlcompressor.velocity;

import com.googlecode.htmlcompressor.compressor.HtmlCompressor;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.runtime.parser.node.Node;

public class HtmlCompressorDirective
extends Directive {
    private static final HtmlCompressor htmlCompressor = new HtmlCompressor();
    private Log log;

    public String getName() {
        return "compressHtml";
    }

    public int getType() {
        return 1;
    }

    public void init(RuntimeServices rs, InternalContextAdapter context, Node node) throws TemplateInitException {
        super.init(rs, context, node);
        this.log = rs.getLog();
        boolean compressJavaScript = rs.getBoolean("userdirective.compressHtml.compressJavaScript", false);
        htmlCompressor.setEnabled(rs.getBoolean("userdirective.compressHtml.enabled", true));
        htmlCompressor.setRemoveComments(rs.getBoolean("userdirective.compressHtml.removeComments", true));
        htmlCompressor.setRemoveMultiSpaces(rs.getBoolean("userdirective.compressHtml.removeMultiSpaces", true));
        htmlCompressor.setRemoveIntertagSpaces(rs.getBoolean("userdirective.compressHtml.removeIntertagSpaces", false));
        htmlCompressor.setRemoveQuotes(rs.getBoolean("userdirective.compressHtml.removeQuotes", false));
        htmlCompressor.setPreserveLineBreaks(rs.getBoolean("userdirective.compressHtml.preserveLineBreaks", false));
        htmlCompressor.setCompressJavaScript(compressJavaScript);
        htmlCompressor.setCompressCss(rs.getBoolean("userdirective.compressHtml.compressCss", false));
        htmlCompressor.setSimpleDoctype(rs.getBoolean("userdirective.compressHtml.simpleDoctype", false));
        htmlCompressor.setRemoveScriptAttributes(rs.getBoolean("userdirective.compressHtml.removeScriptAttributes", false));
        htmlCompressor.setRemoveStyleAttributes(rs.getBoolean("userdirective.compressHtml.removeStyleAttributes", false));
        htmlCompressor.setRemoveLinkAttributes(rs.getBoolean("userdirective.compressHtml.removeLinkAttributes", false));
        htmlCompressor.setRemoveFormAttributes(rs.getBoolean("userdirective.compressHtml.removeFormAttributes", false));
        htmlCompressor.setRemoveInputAttributes(rs.getBoolean("userdirective.compressHtml.removeInputAttributes", false));
        htmlCompressor.setSimpleBooleanAttributes(rs.getBoolean("userdirective.compressHtml.simpleBooleanAttributes", false));
        htmlCompressor.setRemoveJavaScriptProtocol(rs.getBoolean("userdirective.compressHtml.removeJavaScriptProtocol", false));
        htmlCompressor.setRemoveHttpProtocol(rs.getBoolean("userdirective.compressHtml.removeHttpProtocol", false));
        htmlCompressor.setRemoveHttpsProtocol(rs.getBoolean("userdirective.compressHtml.removeHttpsProtocol", false));
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        StringWriter content = new StringWriter();
        node.jjtGetChild(0).render(context, (Writer)content);
        try {
            writer.write(htmlCompressor.compress(content.toString()));
        }
        catch (Exception e) {
            writer.write(content.toString());
            String msg = "Failed to compress content: " + content.toString();
            this.log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        return true;
    }
}

