/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.util.Comparator;
import java.util.Map;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.core.EnumerableAssert;
import org.fest.assertions.data.MapEntry;
import org.fest.assertions.internal.Maps;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapAssert<K, V>
extends AbstractAssert<MapAssert<K, V>, Map<K, V>>
implements EnumerableAssert<MapAssert<K, V>, MapEntry> {
    @VisibleForTesting
    Maps maps = Maps.instance();

    protected MapAssert(Map<K, V> actual) {
        super(actual, MapAssert.class);
    }

    @Override
    public void isNullOrEmpty() {
        this.maps.assertNullOrEmpty(this.info, (Map)this.actual);
    }

    @Override
    public void isEmpty() {
        this.maps.assertEmpty(this.info, (Map)this.actual);
    }

    @Override
    public MapAssert<K, V> isNotEmpty() {
        this.maps.assertNotEmpty(this.info, (Map)this.actual);
        return this;
    }

    @Override
    public MapAssert<K, V> hasSize(int expected) {
        this.maps.assertHasSize(this.info, (Map)this.actual, expected);
        return this;
    }

    @Override
    public MapAssert<K, V> hasSameSizeAs(Object[] other) {
        this.maps.assertHasSameSizeAs((AssertionInfo)this.info, (Map)this.actual, other);
        return this;
    }

    @Override
    public MapAssert<K, V> hasSameSizeAs(Iterable<?> other) {
        this.maps.assertHasSameSizeAs((AssertionInfo)this.info, (Map)this.actual, other);
        return this;
    }

    public MapAssert<K, V> contains(MapEntry ... entries) {
        this.maps.assertContains(this.info, (Map)this.actual, entries);
        return this;
    }

    public MapAssert<K, V> doesNotContain(MapEntry ... entries) {
        this.maps.assertDoesNotContain(this.info, (Map)this.actual, entries);
        return this;
    }

    public MapAssert<K, V> containsKey(K key) {
        this.maps.assertContainsKey(this.info, (Map)this.actual, key);
        return this;
    }

    public MapAssert<K, V> doesNotContainKey(K key) {
        this.maps.assertDoesNotContainKey(this.info, (Map)this.actual, key);
        return this;
    }

    public MapAssert<K, V> containsValue(V value) {
        this.maps.assertContainsValue(this.info, (Map)this.actual, value);
        return this;
    }

    public MapAssert<K, V> doesNotContainValue(V value) {
        this.maps.assertDoesNotContainValue(this.info, (Map)this.actual, value);
        return this;
    }

    @Override
    public MapAssert<K, V> usingElementComparator(Comparator<? super MapEntry> customComparator) {
        throw new UnsupportedOperationException("custom element Comparator is not supported for MapEntry comparison");
    }

    @Override
    public MapAssert<K, V> usingDefaultElementComparator() {
        throw new UnsupportedOperationException("custom element Comparator is not supported for MapEntry comparison");
    }
}

